/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.discovery.v1.model.CredentialDetails;
import com.ibm.watson.developer_cloud.discovery.v1.model.Credentials;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class UpdateCredentialsOptions
extends GenericModel {
    private String environmentId;
    private String credentialId;
    private String sourceType;
    private CredentialDetails credentialDetails;

    private UpdateCredentialsOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.credentialId, "credentialId cannot be empty");
        this.environmentId = builder.environmentId;
        this.credentialId = builder.credentialId;
        this.sourceType = builder.sourceType;
        this.credentialDetails = builder.credentialDetails;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String credentialId() {
        return this.credentialId;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public CredentialDetails credentialDetails() {
        return this.credentialDetails;
    }

    public static class Builder {
        private String environmentId;
        private String credentialId;
        private String sourceType;
        private CredentialDetails credentialDetails;

        private Builder(UpdateCredentialsOptions updateCredentialsOptions) {
            this.environmentId = updateCredentialsOptions.environmentId;
            this.credentialId = updateCredentialsOptions.credentialId;
            this.sourceType = updateCredentialsOptions.sourceType;
            this.credentialDetails = updateCredentialsOptions.credentialDetails;
        }

        public Builder() {
        }

        public Builder(String environmentId, String credentialId) {
            this.environmentId = environmentId;
            this.credentialId = credentialId;
        }

        public UpdateCredentialsOptions build() {
            return new UpdateCredentialsOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder credentialDetails(CredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.sourceType = credentials.getSourceType();
            this.credentialDetails = credentials.getCredentialDetails();
            return this;
        }
    }

    public static interface SourceType {
        public static final String BOX = "box";
        public static final String SALESFORCE = "salesforce";
        public static final String SHAREPOINT = "sharepoint";
    }
}

