/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class TestConfigurationInEnvironmentOptions
extends GenericModel {
    private String environmentId;
    private String configuration;
    private String step;
    private String configurationId;
    private InputStream file;
    private String filename;
    private String metadata;
    private String fileContentType;

    private TestConfigurationInEnvironmentOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.isTrue(builder.file == null || builder.filename != null, "filename cannot be null if file is not null.");
        this.environmentId = builder.environmentId;
        this.configuration = builder.configuration;
        this.step = builder.step;
        this.configurationId = builder.configurationId;
        this.file = builder.file;
        this.filename = builder.filename;
        this.metadata = builder.metadata;
        this.fileContentType = builder.fileContentType;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String configuration() {
        return this.configuration;
    }

    public String step() {
        return this.step;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public InputStream file() {
        return this.file;
    }

    public String filename() {
        return this.filename;
    }

    public String metadata() {
        return this.metadata;
    }

    public String fileContentType() {
        return this.fileContentType;
    }

    public static class Builder {
        private String environmentId;
        private String configuration;
        private String step;
        private String configurationId;
        private InputStream file;
        private String filename;
        private String metadata;
        private String fileContentType;

        private Builder(TestConfigurationInEnvironmentOptions testConfigurationInEnvironmentOptions) {
            this.environmentId = testConfigurationInEnvironmentOptions.environmentId;
            this.configuration = testConfigurationInEnvironmentOptions.configuration;
            this.step = testConfigurationInEnvironmentOptions.step;
            this.configurationId = testConfigurationInEnvironmentOptions.configurationId;
            this.file = testConfigurationInEnvironmentOptions.file;
            this.filename = testConfigurationInEnvironmentOptions.filename;
            this.metadata = testConfigurationInEnvironmentOptions.metadata;
            this.fileContentType = testConfigurationInEnvironmentOptions.fileContentType;
        }

        public Builder() {
        }

        public Builder(String environmentId) {
            this.environmentId = environmentId;
        }

        public TestConfigurationInEnvironmentOptions build() {
            return new TestConfigurationInEnvironmentOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder step(String step) {
            this.step = step;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }

    public static interface Step {
        public static final String HTML_INPUT = "html_input";
        public static final String HTML_OUTPUT = "html_output";
        public static final String JSON_OUTPUT = "json_output";
        public static final String JSON_NORMALIZATIONS_OUTPUT = "json_normalizations_output";
        public static final String ENRICHMENTS_OUTPUT = "enrichments_output";
        public static final String NORMALIZATIONS_OUTPUT = "normalizations_output";
    }
}

