/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.discovery.v1.model.QueryEntitiesContext;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryRelationsEntity;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryRelationsFilter;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class QueryRelationsOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private List<QueryRelationsEntity> entities;
    private QueryEntitiesContext context;
    private String sort;
    private QueryRelationsFilter filter;
    private Long count;
    private Long evidenceCount;

    private QueryRelationsOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.entities = builder.entities;
        this.context = builder.context;
        this.sort = builder.sort;
        this.filter = builder.filter;
        this.count = builder.count;
        this.evidenceCount = builder.evidenceCount;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<QueryRelationsEntity> entities() {
        return this.entities;
    }

    public QueryEntitiesContext context() {
        return this.context;
    }

    public String sort() {
        return this.sort;
    }

    public QueryRelationsFilter filter() {
        return this.filter;
    }

    public Long count() {
        return this.count;
    }

    public Long evidenceCount() {
        return this.evidenceCount;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private List<QueryRelationsEntity> entities;
        private QueryEntitiesContext context;
        private String sort;
        private QueryRelationsFilter filter;
        private Long count;
        private Long evidenceCount;

        private Builder(QueryRelationsOptions queryRelationsOptions) {
            this.environmentId = queryRelationsOptions.environmentId;
            this.collectionId = queryRelationsOptions.collectionId;
            this.entities = queryRelationsOptions.entities;
            this.context = queryRelationsOptions.context;
            this.sort = queryRelationsOptions.sort;
            this.filter = queryRelationsOptions.filter;
            this.count = queryRelationsOptions.count;
            this.evidenceCount = queryRelationsOptions.evidenceCount;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public QueryRelationsOptions build() {
            return new QueryRelationsOptions(this);
        }

        public Builder addEntities(QueryRelationsEntity entities) {
            Validator.notNull(entities, "entities cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<QueryRelationsEntity>();
            }
            this.entities.add(entities);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder entities(List<QueryRelationsEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder context(QueryEntitiesContext context) {
            this.context = context;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder filter(QueryRelationsFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder evidenceCount(long evidenceCount) {
            this.evidenceCount = evidenceCount;
            return this;
        }
    }

    public static interface Sort {
        public static final String SCORE = "score";
        public static final String FREQUENCY = "frequency";
    }
}

