/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QueryOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String filter;
    private String query;
    private String naturalLanguageQuery;
    private Boolean passages;
    private String aggregation;
    private Long count;
    private String returnFields;
    private Long offset;
    private String sort;
    private Boolean highlight;
    private String passagesFields;
    private Long passagesCount;
    private Long passagesCharacters;
    private Boolean deduplicate;
    private String deduplicateField;
    private String collectionIds;
    private Boolean similar;
    private String similarDocumentIds;
    private String similarFields;
    private String bias;
    private Boolean loggingOptOut;

    private QueryOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.filter = builder.filter;
        this.query = builder.query;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.passages = builder.passages;
        this.aggregation = builder.aggregation;
        this.count = builder.count;
        this.returnFields = builder.returnFields;
        this.offset = builder.offset;
        this.sort = builder.sort;
        this.highlight = builder.highlight;
        this.passagesFields = builder.passagesFields;
        this.passagesCount = builder.passagesCount;
        this.passagesCharacters = builder.passagesCharacters;
        this.deduplicate = builder.deduplicate;
        this.deduplicateField = builder.deduplicateField;
        this.collectionIds = builder.collectionIds;
        this.similar = builder.similar;
        this.similarDocumentIds = builder.similarDocumentIds;
        this.similarFields = builder.similarFields;
        this.bias = builder.bias;
        this.loggingOptOut = builder.loggingOptOut;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public Boolean passages() {
        return this.passages;
    }

    public String aggregation() {
        return this.aggregation;
    }

    public Long count() {
        return this.count;
    }

    public List<String> returnFields() {
        if (this.returnFields != null) {
            return Arrays.asList(this.returnFields.split(","));
        }
        return null;
    }

    public Long offset() {
        return this.offset;
    }

    public List<String> sort() {
        if (this.sort != null) {
            return Arrays.asList(this.sort.split(","));
        }
        return null;
    }

    public Boolean highlight() {
        return this.highlight;
    }

    public List<String> passagesFields() {
        if (this.passagesFields != null) {
            return Arrays.asList(this.passagesFields.split(","));
        }
        return null;
    }

    public Long passagesCount() {
        return this.passagesCount;
    }

    public Long passagesCharacters() {
        return this.passagesCharacters;
    }

    public Boolean deduplicate() {
        return this.deduplicate;
    }

    public String deduplicateField() {
        return this.deduplicateField;
    }

    public List<String> collectionIds() {
        if (this.collectionIds != null) {
            return Arrays.asList(this.collectionIds.split(","));
        }
        return null;
    }

    public Boolean similar() {
        return this.similar;
    }

    public List<String> similarDocumentIds() {
        if (this.similarDocumentIds != null) {
            return Arrays.asList(this.similarDocumentIds.split(","));
        }
        return null;
    }

    public List<String> similarFields() {
        if (this.similarFields != null) {
            return Arrays.asList(this.similarFields.split(","));
        }
        return null;
    }

    public String bias() {
        return this.bias;
    }

    public Boolean loggingOptOut() {
        return this.loggingOptOut;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String filter;
        private String query;
        private String naturalLanguageQuery;
        private Boolean passages;
        private String aggregation;
        private Long count;
        private String returnFields;
        private Long offset;
        private String sort;
        private Boolean highlight;
        private String passagesFields;
        private Long passagesCount;
        private Long passagesCharacters;
        private Boolean deduplicate;
        private String deduplicateField;
        private String collectionIds;
        private Boolean similar;
        private String similarDocumentIds;
        private String similarFields;
        private String bias;
        private Boolean loggingOptOut;

        private Builder(QueryOptions queryOptions) {
            this.environmentId = queryOptions.environmentId;
            this.collectionId = queryOptions.collectionId;
            this.filter = queryOptions.filter;
            this.query = queryOptions.query;
            this.naturalLanguageQuery = queryOptions.naturalLanguageQuery;
            this.passages = queryOptions.passages;
            this.aggregation = queryOptions.aggregation;
            this.count = queryOptions.count;
            this.returnFields = queryOptions.returnFields;
            this.offset = queryOptions.offset;
            this.sort = queryOptions.sort;
            this.highlight = queryOptions.highlight;
            this.passagesFields = queryOptions.passagesFields;
            this.passagesCount = queryOptions.passagesCount;
            this.passagesCharacters = queryOptions.passagesCharacters;
            this.deduplicate = queryOptions.deduplicate;
            this.deduplicateField = queryOptions.deduplicateField;
            this.collectionIds = queryOptions.collectionIds;
            this.similar = queryOptions.similar;
            this.similarDocumentIds = queryOptions.similarDocumentIds;
            this.similarFields = queryOptions.similarFields;
            this.bias = queryOptions.bias;
            this.loggingOptOut = queryOptions.loggingOptOut;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public QueryOptions build() {
            return new QueryOptions(this);
        }

        public Builder addReturnField(String returnField) {
            Validator.notNull(returnField, "returnField cannot be null");
            this.returnFields = this.returnFields == null ? returnField : this.returnFields + String.format(",%s", returnField);
            return this;
        }

        public Builder addSort(String sort) {
            Validator.notNull(sort, "sort cannot be null");
            this.sort = this.sort == null ? sort : this.sort + String.format(",%s", sort);
            return this;
        }

        public Builder addPassagesFields(String passagesFields) {
            Validator.notNull(passagesFields, "passagesFields cannot be null");
            this.passagesFields = this.passagesFields == null ? passagesFields : this.passagesFields + String.format(",%s", passagesFields);
            return this;
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull(collectionIds, "collectionIds cannot be null");
            this.collectionIds = this.collectionIds == null ? collectionIds : this.collectionIds + String.format(",%s", collectionIds);
            return this;
        }

        public Builder addSimilarDocumentIds(String similarDocumentIds) {
            Validator.notNull(similarDocumentIds, "similarDocumentIds cannot be null");
            this.similarDocumentIds = this.similarDocumentIds == null ? similarDocumentIds : this.similarDocumentIds + String.format(",%s", similarDocumentIds);
            return this;
        }

        public Builder addSimilarFields(String similarFields) {
            Validator.notNull(similarFields, "similarFields cannot be null");
            this.similarFields = this.similarFields == null ? similarFields : this.similarFields + String.format(",%s", similarFields);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder passages(Boolean passages) {
            this.passages = passages;
            return this;
        }

        public Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder returnFields(String returnFields) {
            this.returnFields = returnFields;
            return this;
        }

        public Builder returnFields(List<String> returnFields) {
            this.returnFields = StringUtils.join(returnFields, ',');
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder sort(List<String> sort) {
            this.sort = StringUtils.join(sort, ',');
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder passagesFields(String passagesFields) {
            this.passagesFields = passagesFields;
            return this;
        }

        public Builder passagesFields(List<String> passagesFields) {
            this.passagesFields = StringUtils.join(passagesFields, ',');
            return this;
        }

        public Builder passagesCount(long passagesCount) {
            this.passagesCount = passagesCount;
            return this;
        }

        public Builder passagesCharacters(long passagesCharacters) {
            this.passagesCharacters = passagesCharacters;
            return this;
        }

        public Builder deduplicate(Boolean deduplicate) {
            this.deduplicate = deduplicate;
            return this;
        }

        public Builder deduplicateField(String deduplicateField) {
            this.deduplicateField = deduplicateField;
            return this;
        }

        public Builder collectionIds(String collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = StringUtils.join(collectionIds, ',');
            return this;
        }

        public Builder similar(Boolean similar) {
            this.similar = similar;
            return this;
        }

        public Builder similarDocumentIds(String similarDocumentIds) {
            this.similarDocumentIds = similarDocumentIds;
            return this;
        }

        public Builder similarDocumentIds(List<String> similarDocumentIds) {
            this.similarDocumentIds = StringUtils.join(similarDocumentIds, ',');
            return this;
        }

        public Builder similarFields(String similarFields) {
            this.similarFields = similarFields;
            return this;
        }

        public Builder similarFields(List<String> similarFields) {
            this.similarFields = StringUtils.join(similarFields, ',');
            return this;
        }

        public Builder bias(String bias) {
            this.bias = bias;
            return this;
        }

        public Builder loggingOptOut(Boolean loggingOptOut) {
            this.loggingOptOut = loggingOptOut;
            return this;
        }
    }
}

