/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class NluEnrichmentSentiment
extends GenericModel {
    private Boolean document;
    private List<String> targets;

    private NluEnrichmentSentiment(Builder builder) {
        this.document = builder.document;
        this.targets = builder.targets;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Boolean document() {
        return this.document;
    }

    public List<String> targets() {
        return this.targets;
    }

    public static class Builder {
        private Boolean document;
        private List<String> targets;

        private Builder(NluEnrichmentSentiment nluEnrichmentSentiment) {
            this.document = nluEnrichmentSentiment.document;
            this.targets = nluEnrichmentSentiment.targets;
        }

        public Builder() {
        }

        public NluEnrichmentSentiment build() {
            return new NluEnrichmentSentiment(this);
        }

        public Builder addTarget(String target) {
            Validator.notNull(target, "target cannot be null");
            if (this.targets == null) {
                this.targets = new ArrayList<String>();
            }
            this.targets.add(target);
            return this;
        }

        public Builder document(Boolean document) {
            this.document = document;
            return this;
        }

        public Builder targets(List<String> targets) {
            this.targets = targets;
            return this;
        }
    }
}

