/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class ListTrainingExamplesOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String queryId;

    private ListTrainingExamplesOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        Validator.notEmpty(builder.queryId, "queryId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.queryId = builder.queryId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String queryId() {
        return this.queryId;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String queryId;

        private Builder(ListTrainingExamplesOptions listTrainingExamplesOptions) {
            this.environmentId = listTrainingExamplesOptions.environmentId;
            this.collectionId = listTrainingExamplesOptions.collectionId;
            this.queryId = listTrainingExamplesOptions.queryId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String queryId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.queryId = queryId;
        }

        public ListTrainingExamplesOptions build() {
            return new ListTrainingExamplesOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }
    }
}

