/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetTrainingExampleOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String queryId;
    private String exampleId;

    private GetTrainingExampleOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        Validator.notEmpty(builder.queryId, "queryId cannot be empty");
        Validator.notEmpty(builder.exampleId, "exampleId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.queryId = builder.queryId;
        this.exampleId = builder.exampleId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String queryId() {
        return this.queryId;
    }

    public String exampleId() {
        return this.exampleId;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String queryId;
        private String exampleId;

        private Builder(GetTrainingExampleOptions getTrainingExampleOptions) {
            this.environmentId = getTrainingExampleOptions.environmentId;
            this.collectionId = getTrainingExampleOptions.collectionId;
            this.queryId = getTrainingExampleOptions.queryId;
            this.exampleId = getTrainingExampleOptions.exampleId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String queryId, String exampleId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.queryId = queryId;
            this.exampleId = exampleId;
        }

        public GetTrainingExampleOptions build() {
            return new GetTrainingExampleOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder exampleId(String exampleId) {
            this.exampleId = exampleId;
            return this;
        }
    }
}

