/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetDocumentStatusOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String documentId;

    private GetDocumentStatusOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        Validator.notEmpty(builder.documentId, "documentId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.documentId = builder.documentId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String documentId() {
        return this.documentId;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String documentId;

        private Builder(GetDocumentStatusOptions getDocumentStatusOptions) {
            this.environmentId = getDocumentStatusOptions.environmentId;
            this.collectionId = getDocumentStatusOptions.collectionId;
            this.documentId = getDocumentStatusOptions.documentId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String documentId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.documentId = documentId;
        }

        public GetDocumentStatusOptions build() {
            return new GetDocumentStatusOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }
    }
}

