/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.discovery.v1.model.TrainingExample;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class CreateTrainingExampleOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String queryId;
    private String documentId;
    private String crossReference;
    private Long relevance;

    private CreateTrainingExampleOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        Validator.notEmpty(builder.queryId, "queryId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.queryId = builder.queryId;
        this.documentId = builder.documentId;
        this.crossReference = builder.crossReference;
        this.relevance = builder.relevance;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String queryId() {
        return this.queryId;
    }

    public String documentId() {
        return this.documentId;
    }

    public String crossReference() {
        return this.crossReference;
    }

    public Long relevance() {
        return this.relevance;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String queryId;
        private String documentId;
        private String crossReference;
        private Long relevance;

        private Builder(CreateTrainingExampleOptions createTrainingExampleOptions) {
            this.environmentId = createTrainingExampleOptions.environmentId;
            this.collectionId = createTrainingExampleOptions.collectionId;
            this.queryId = createTrainingExampleOptions.queryId;
            this.documentId = createTrainingExampleOptions.documentId;
            this.crossReference = createTrainingExampleOptions.crossReference;
            this.relevance = createTrainingExampleOptions.relevance;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String queryId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.queryId = queryId;
        }

        public CreateTrainingExampleOptions build() {
            return new CreateTrainingExampleOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public Builder crossReference(String crossReference) {
            this.crossReference = crossReference;
            return this;
        }

        public Builder relevance(long relevance) {
            this.relevance = relevance;
            return this;
        }

        public Builder trainingExample(TrainingExample trainingExample) {
            this.documentId = trainingExample.getDocumentId();
            this.crossReference = trainingExample.getCrossReference();
            this.relevance = trainingExample.getRelevance();
            return this;
        }
    }
}

