/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class CreateEnvironmentOptions
extends GenericModel {
    private String name;
    private String description;
    private String size;

    private CreateEnvironmentOptions(Builder builder) {
        Validator.notNull(builder.name, "name cannot be null");
        this.name = builder.name;
        this.description = builder.description;
        this.size = builder.size;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String size() {
        return this.size;
    }

    public static class Builder {
        private String name;
        private String description;
        private String size;

        private Builder(CreateEnvironmentOptions createEnvironmentOptions) {
            this.name = createEnvironmentOptions.name;
            this.description = createEnvironmentOptions.description;
            this.size = createEnvironmentOptions.size;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public CreateEnvironmentOptions build() {
            return new CreateEnvironmentOptions(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder size(Long size) {
            return this;
        }
    }

    public static interface Size {
        public static final String LT = "LT";
        public static final String XS = "XS";
        public static final String S = "S";
        public static final String MS = "MS";
        public static final String M = "M";
        public static final String ML = "ML";
        public static final String L = "L";
        public static final String XL = "XL";
        public static final String XXL = "XXL";
        public static final String XXXL = "XXXL";
    }
}

