/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class CreateCollectionOptions
extends GenericModel {
    private String environmentId;
    private String name;
    private String description;
    private String configurationId;
    private String language;

    private CreateCollectionOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notNull(builder.name, "name cannot be null");
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
        this.configurationId = builder.configurationId;
        this.language = builder.language;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String language() {
        return this.language;
    }

    public static class Builder {
        private String environmentId;
        private String name;
        private String description;
        private String configurationId;
        private String language;

        private Builder(CreateCollectionOptions createCollectionOptions) {
            this.environmentId = createCollectionOptions.environmentId;
            this.name = createCollectionOptions.name;
            this.description = createCollectionOptions.description;
            this.configurationId = createCollectionOptions.configurationId;
            this.language = createCollectionOptions.language;
        }

        public Builder() {
        }

        public Builder(String environmentId, String name) {
            this.environmentId = environmentId;
            this.name = name;
        }

        public CreateCollectionOptions build() {
            return new CreateCollectionOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }
    }

    public static interface Language {
        public static final String EN = "en";
        public static final String ES = "es";
        public static final String DE = "de";
        public static final String AR = "ar";
        public static final String FR = "fr";
        public static final String IT = "it";
        public static final String JA = "ja";
        public static final String KO = "ko";
        public static final String PT = "pt";
        public static final String NL = "nl";
    }
}

