/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.discovery.v1.model.AddDocumentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.AddTrainingDataOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.Collection;
import com.ibm.watson.developer_cloud.discovery.v1.model.Configuration;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateCollectionOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateConfigurationOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateCredentialsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateEnvironmentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateEventOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateEventResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateExpansionsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateTokenizationDictionaryOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.CreateTrainingExampleOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.Credentials;
import com.ibm.watson.developer_cloud.discovery.v1.model.CredentialsList;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteAllTrainingDataOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteCollectionOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteConfigurationOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteCredentialsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteDocumentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteEnvironmentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteExpansionsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteTokenizationDictionaryOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteTrainingDataOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteTrainingExampleOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DeleteUserDataOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.DocumentAccepted;
import com.ibm.watson.developer_cloud.discovery.v1.model.DocumentStatus;
import com.ibm.watson.developer_cloud.discovery.v1.model.Environment;
import com.ibm.watson.developer_cloud.discovery.v1.model.Expansions;
import com.ibm.watson.developer_cloud.discovery.v1.model.FederatedQueryNoticesOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.FederatedQueryOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetCollectionOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetConfigurationOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetCredentialsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetDocumentStatusOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetEnvironmentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetMetricsEventRateOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetMetricsQueryEventOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetMetricsQueryNoResultsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetMetricsQueryOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetMetricsQueryTokenEventOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetTokenizationDictionaryStatusOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetTrainingDataOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.GetTrainingExampleOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListCollectionFieldsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListCollectionFieldsResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListCollectionsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListCollectionsResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListConfigurationsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListConfigurationsResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListCredentialsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListEnvironmentsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListEnvironmentsResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListExpansionsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListFieldsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListTrainingDataOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.ListTrainingExamplesOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.LogQueryResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.MetricResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.MetricTokenResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryEntitiesOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryEntitiesResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryLogOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryNoticesOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryNoticesResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryRelationsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryRelationsResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.TestConfigurationInEnvironmentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.TestDocument;
import com.ibm.watson.developer_cloud.discovery.v1.model.TokenDictStatusResponse;
import com.ibm.watson.developer_cloud.discovery.v1.model.TrainingDataSet;
import com.ibm.watson.developer_cloud.discovery.v1.model.TrainingExample;
import com.ibm.watson.developer_cloud.discovery.v1.model.TrainingExampleList;
import com.ibm.watson.developer_cloud.discovery.v1.model.TrainingQuery;
import com.ibm.watson.developer_cloud.discovery.v1.model.UpdateCollectionOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.UpdateConfigurationOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.UpdateCredentialsOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.UpdateDocumentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.UpdateEnvironmentOptions;
import com.ibm.watson.developer_cloud.discovery.v1.model.UpdateTrainingExampleOptions;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;

public class Discovery
extends WatsonService {
    private static final String SERVICE_NAME = "discovery";
    private static final String URL = "https://gateway.watsonplatform.net/discovery/api";
    private String versionDate;

    public Discovery(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue(versionDate != null && !versionDate.isEmpty(), "version cannot be null.");
        this.versionDate = versionDate;
    }

    public Discovery(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public Discovery(String versionDate, IamOptions iamOptions) {
        this(versionDate);
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<Environment> createEnvironment(CreateEnvironmentOptions createEnvironmentOptions) {
        Validator.notNull(createEnvironmentOptions, "createEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createEnvironmentOptions.name());
        if (createEnvironmentOptions.description() != null) {
            contentJson.addProperty("description", createEnvironmentOptions.description());
        }
        if (createEnvironmentOptions.size() != null) {
            contentJson.addProperty("size", createEnvironmentOptions.size());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Environment.class));
    }

    public ServiceCall<Void> deleteEnvironment(DeleteEnvironmentOptions deleteEnvironmentOptions) {
        Validator.notNull(deleteEnvironmentOptions, "deleteEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        String[] pathParameters = new String[]{deleteEnvironmentOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Environment> getEnvironment(GetEnvironmentOptions getEnvironmentOptions) {
        Validator.notNull(getEnvironmentOptions, "getEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        String[] pathParameters = new String[]{getEnvironmentOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Environment.class));
    }

    public ServiceCall<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsOptions listEnvironmentsOptions) {
        String[] pathSegments = new String[]{"v1/environments"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (listEnvironmentsOptions != null && listEnvironmentsOptions.name() != null) {
            builder.query("name", listEnvironmentsOptions.name());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ListEnvironmentsResponse.class));
    }

    public ServiceCall<ListEnvironmentsResponse> listEnvironments() {
        return this.listEnvironments(null);
    }

    public ServiceCall<ListCollectionFieldsResponse> listFields(ListFieldsOptions listFieldsOptions) {
        Validator.notNull(listFieldsOptions, "listFieldsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "fields"};
        String[] pathParameters = new String[]{listFieldsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        builder.query("collection_ids", RequestUtils.join(listFieldsOptions.collectionIds(), ","));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ListCollectionFieldsResponse.class));
    }

    public ServiceCall<Environment> updateEnvironment(UpdateEnvironmentOptions updateEnvironmentOptions) {
        Validator.notNull(updateEnvironmentOptions, "updateEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        String[] pathParameters = new String[]{updateEnvironmentOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (updateEnvironmentOptions.name() != null) {
            contentJson.addProperty("name", updateEnvironmentOptions.name());
        }
        if (updateEnvironmentOptions.description() != null) {
            contentJson.addProperty("description", updateEnvironmentOptions.description());
        }
        if (updateEnvironmentOptions.size() != null) {
            contentJson.addProperty("size", updateEnvironmentOptions.size());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Environment.class));
    }

    public ServiceCall<Configuration> createConfiguration(CreateConfigurationOptions createConfigurationOptions) {
        Validator.notNull(createConfigurationOptions, "createConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{createConfigurationOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (createConfigurationOptions.name() != null) {
            contentJson.addProperty("name", createConfigurationOptions.name());
        }
        if (createConfigurationOptions.description() != null) {
            contentJson.addProperty("description", createConfigurationOptions.description());
        }
        if (createConfigurationOptions.conversions() != null) {
            contentJson.add("conversions", GsonSingleton.getGson().toJsonTree(createConfigurationOptions.conversions()));
        }
        if (createConfigurationOptions.enrichments() != null) {
            contentJson.add("enrichments", GsonSingleton.getGson().toJsonTree(createConfigurationOptions.enrichments()));
        }
        if (createConfigurationOptions.normalizations() != null) {
            contentJson.add("normalizations", GsonSingleton.getGson().toJsonTree(createConfigurationOptions.normalizations()));
        }
        if (createConfigurationOptions.source() != null) {
            contentJson.add("source", GsonSingleton.getGson().toJsonTree(createConfigurationOptions.source()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Configuration.class));
    }

    public ServiceCall<Void> deleteConfiguration(DeleteConfigurationOptions deleteConfigurationOptions) {
        Validator.notNull(deleteConfigurationOptions, "deleteConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{deleteConfigurationOptions.environmentId(), deleteConfigurationOptions.configurationId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Configuration> getConfiguration(GetConfigurationOptions getConfigurationOptions) {
        Validator.notNull(getConfigurationOptions, "getConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{getConfigurationOptions.environmentId(), getConfigurationOptions.configurationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Configuration.class));
    }

    public ServiceCall<ListConfigurationsResponse> listConfigurations(ListConfigurationsOptions listConfigurationsOptions) {
        Validator.notNull(listConfigurationsOptions, "listConfigurationsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{listConfigurationsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        if (listConfigurationsOptions.name() != null) {
            builder.query("name", listConfigurationsOptions.name());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ListConfigurationsResponse.class));
    }

    public ServiceCall<Configuration> updateConfiguration(UpdateConfigurationOptions updateConfigurationOptions) {
        Validator.notNull(updateConfigurationOptions, "updateConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{updateConfigurationOptions.environmentId(), updateConfigurationOptions.configurationId()};
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (updateConfigurationOptions.name() != null) {
            contentJson.addProperty("name", updateConfigurationOptions.name());
        }
        if (updateConfigurationOptions.description() != null) {
            contentJson.addProperty("description", updateConfigurationOptions.description());
        }
        if (updateConfigurationOptions.conversions() != null) {
            contentJson.add("conversions", GsonSingleton.getGson().toJsonTree(updateConfigurationOptions.conversions()));
        }
        if (updateConfigurationOptions.enrichments() != null) {
            contentJson.add("enrichments", GsonSingleton.getGson().toJsonTree(updateConfigurationOptions.enrichments()));
        }
        if (updateConfigurationOptions.normalizations() != null) {
            contentJson.add("normalizations", GsonSingleton.getGson().toJsonTree(updateConfigurationOptions.normalizations()));
        }
        if (updateConfigurationOptions.source() != null) {
            contentJson.add("source", GsonSingleton.getGson().toJsonTree(updateConfigurationOptions.source()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Configuration.class));
    }

    public ServiceCall<TestDocument> testConfigurationInEnvironment(TestConfigurationInEnvironmentOptions testConfigurationInEnvironmentOptions) {
        Validator.notNull(testConfigurationInEnvironmentOptions, "testConfigurationInEnvironmentOptions cannot be null");
        Validator.isTrue(testConfigurationInEnvironmentOptions.configuration() != null || testConfigurationInEnvironmentOptions.file() != null || testConfigurationInEnvironmentOptions.metadata() != null, "At least one of configuration, file, or metadata must be supplied.");
        String[] pathSegments = new String[]{"v1/environments", "preview"};
        String[] pathParameters = new String[]{testConfigurationInEnvironmentOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        if (testConfigurationInEnvironmentOptions.step() != null) {
            builder.query("step", testConfigurationInEnvironmentOptions.step());
        }
        if (testConfigurationInEnvironmentOptions.configurationId() != null) {
            builder.query("configuration_id", testConfigurationInEnvironmentOptions.configurationId());
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (testConfigurationInEnvironmentOptions.configuration() != null) {
            multipartBuilder.addFormDataPart("configuration", testConfigurationInEnvironmentOptions.configuration());
        }
        if (testConfigurationInEnvironmentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody(testConfigurationInEnvironmentOptions.file(), testConfigurationInEnvironmentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", testConfigurationInEnvironmentOptions.filename(), fileBody);
        }
        if (testConfigurationInEnvironmentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", testConfigurationInEnvironmentOptions.metadata());
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TestDocument.class));
    }

    public ServiceCall<Collection> createCollection(CreateCollectionOptions createCollectionOptions) {
        Validator.notNull(createCollectionOptions, "createCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{createCollectionOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createCollectionOptions.name());
        if (createCollectionOptions.description() != null) {
            contentJson.addProperty("description", createCollectionOptions.description());
        }
        if (createCollectionOptions.configurationId() != null) {
            contentJson.addProperty("configuration_id", createCollectionOptions.configurationId());
        }
        if (createCollectionOptions.language() != null) {
            contentJson.addProperty("language", createCollectionOptions.language());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Collection.class));
    }

    public ServiceCall<Void> deleteCollection(DeleteCollectionOptions deleteCollectionOptions) {
        Validator.notNull(deleteCollectionOptions, "deleteCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{deleteCollectionOptions.environmentId(), deleteCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Collection> getCollection(GetCollectionOptions getCollectionOptions) {
        Validator.notNull(getCollectionOptions, "getCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{getCollectionOptions.environmentId(), getCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Collection.class));
    }

    public ServiceCall<ListCollectionFieldsResponse> listCollectionFields(ListCollectionFieldsOptions listCollectionFieldsOptions) {
        Validator.notNull(listCollectionFieldsOptions, "listCollectionFieldsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "fields"};
        String[] pathParameters = new String[]{listCollectionFieldsOptions.environmentId(), listCollectionFieldsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ListCollectionFieldsResponse.class));
    }

    public ServiceCall<ListCollectionsResponse> listCollections(ListCollectionsOptions listCollectionsOptions) {
        Validator.notNull(listCollectionsOptions, "listCollectionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{listCollectionsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        if (listCollectionsOptions.name() != null) {
            builder.query("name", listCollectionsOptions.name());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ListCollectionsResponse.class));
    }

    public ServiceCall<Collection> updateCollection(UpdateCollectionOptions updateCollectionOptions) {
        Validator.notNull(updateCollectionOptions, "updateCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{updateCollectionOptions.environmentId(), updateCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (updateCollectionOptions.name() != null) {
            contentJson.addProperty("name", updateCollectionOptions.name());
        }
        if (updateCollectionOptions.description() != null) {
            contentJson.addProperty("description", updateCollectionOptions.description());
        }
        if (updateCollectionOptions.configurationId() != null) {
            contentJson.addProperty("configuration_id", updateCollectionOptions.configurationId());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Collection.class));
    }

    public ServiceCall<Expansions> createExpansions(CreateExpansionsOptions createExpansionsOptions) {
        Validator.notNull(createExpansionsOptions, "createExpansionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "expansions"};
        String[] pathParameters = new String[]{createExpansionsOptions.environmentId(), createExpansionsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (createExpansionsOptions.expansions() != null) {
            contentJson.add("expansions", GsonSingleton.getGson().toJsonTree(createExpansionsOptions.expansions()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Expansions.class));
    }

    public ServiceCall<TokenDictStatusResponse> createTokenizationDictionary(CreateTokenizationDictionaryOptions createTokenizationDictionaryOptions) {
        Validator.notNull(createTokenizationDictionaryOptions, "createTokenizationDictionaryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/tokenization_dictionary"};
        String[] pathParameters = new String[]{createTokenizationDictionaryOptions.environmentId(), createTokenizationDictionaryOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (createTokenizationDictionaryOptions.tokenizationRules() != null) {
            contentJson.add("tokenization_rules", GsonSingleton.getGson().toJsonTree(createTokenizationDictionaryOptions.tokenizationRules()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TokenDictStatusResponse.class));
    }

    public ServiceCall<Void> deleteExpansions(DeleteExpansionsOptions deleteExpansionsOptions) {
        Validator.notNull(deleteExpansionsOptions, "deleteExpansionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "expansions"};
        String[] pathParameters = new String[]{deleteExpansionsOptions.environmentId(), deleteExpansionsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteTokenizationDictionary(DeleteTokenizationDictionaryOptions deleteTokenizationDictionaryOptions) {
        Validator.notNull(deleteTokenizationDictionaryOptions, "deleteTokenizationDictionaryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/tokenization_dictionary"};
        String[] pathParameters = new String[]{deleteTokenizationDictionaryOptions.environmentId(), deleteTokenizationDictionaryOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<TokenDictStatusResponse> getTokenizationDictionaryStatus(GetTokenizationDictionaryStatusOptions getTokenizationDictionaryStatusOptions) {
        Validator.notNull(getTokenizationDictionaryStatusOptions, "getTokenizationDictionaryStatusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/tokenization_dictionary"};
        String[] pathParameters = new String[]{getTokenizationDictionaryStatusOptions.environmentId(), getTokenizationDictionaryStatusOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TokenDictStatusResponse.class));
    }

    public ServiceCall<Expansions> listExpansions(ListExpansionsOptions listExpansionsOptions) {
        Validator.notNull(listExpansionsOptions, "listExpansionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "expansions"};
        String[] pathParameters = new String[]{listExpansionsOptions.environmentId(), listExpansionsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Expansions.class));
    }

    public ServiceCall<DocumentAccepted> addDocument(AddDocumentOptions addDocumentOptions) {
        Validator.notNull(addDocumentOptions, "addDocumentOptions cannot be null");
        Validator.isTrue(addDocumentOptions.file() != null || addDocumentOptions.metadata() != null, "At least one of file or metadata must be supplied.");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{addDocumentOptions.environmentId(), addDocumentOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (addDocumentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody(addDocumentOptions.file(), addDocumentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", addDocumentOptions.filename(), fileBody);
        }
        if (addDocumentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", addDocumentOptions.metadata());
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DocumentAccepted.class));
    }

    public ServiceCall<Void> deleteDocument(DeleteDocumentOptions deleteDocumentOptions) {
        Validator.notNull(deleteDocumentOptions, "deleteDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{deleteDocumentOptions.environmentId(), deleteDocumentOptions.collectionId(), deleteDocumentOptions.documentId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<DocumentStatus> getDocumentStatus(GetDocumentStatusOptions getDocumentStatusOptions) {
        Validator.notNull(getDocumentStatusOptions, "getDocumentStatusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{getDocumentStatusOptions.environmentId(), getDocumentStatusOptions.collectionId(), getDocumentStatusOptions.documentId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DocumentStatus.class));
    }

    public ServiceCall<DocumentAccepted> updateDocument(UpdateDocumentOptions updateDocumentOptions) {
        Validator.notNull(updateDocumentOptions, "updateDocumentOptions cannot be null");
        Validator.isTrue(updateDocumentOptions.file() != null || updateDocumentOptions.metadata() != null, "At least one of file or metadata must be supplied.");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{updateDocumentOptions.environmentId(), updateDocumentOptions.collectionId(), updateDocumentOptions.documentId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (updateDocumentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody(updateDocumentOptions.file(), updateDocumentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", updateDocumentOptions.filename(), fileBody);
        }
        if (updateDocumentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", updateDocumentOptions.metadata());
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DocumentAccepted.class));
    }

    public ServiceCall<QueryResponse> federatedQuery(FederatedQueryOptions federatedQueryOptions) {
        Validator.notNull(federatedQueryOptions, "federatedQueryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "query"};
        String[] pathParameters = new String[]{federatedQueryOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        if (federatedQueryOptions.loggingOptOut() != null) {
            builder.header("X-Watson-Logging-Opt-Out", federatedQueryOptions.loggingOptOut());
        }
        JsonObject contentJson = new JsonObject();
        if (federatedQueryOptions.filter() != null) {
            contentJson.addProperty("filter", federatedQueryOptions.filter());
        }
        if (federatedQueryOptions.query() != null) {
            contentJson.addProperty("query", federatedQueryOptions.query());
        }
        if (federatedQueryOptions.naturalLanguageQuery() != null) {
            contentJson.addProperty("natural_language_query", federatedQueryOptions.naturalLanguageQuery());
        }
        if (federatedQueryOptions.passages() != null) {
            contentJson.addProperty("passages", federatedQueryOptions.passages());
        }
        if (federatedQueryOptions.aggregation() != null) {
            contentJson.addProperty("aggregation", federatedQueryOptions.aggregation());
        }
        if (federatedQueryOptions.count() != null) {
            contentJson.addProperty("count", federatedQueryOptions.count());
        }
        if (federatedQueryOptions.returnFields() != null) {
            contentJson.addProperty("return", StringUtils.join(federatedQueryOptions.returnFields(), ","));
        }
        if (federatedQueryOptions.offset() != null) {
            contentJson.addProperty("offset", federatedQueryOptions.offset());
        }
        if (federatedQueryOptions.sort() != null) {
            contentJson.addProperty("sort", StringUtils.join(federatedQueryOptions.sort(), ","));
        }
        if (federatedQueryOptions.highlight() != null) {
            contentJson.addProperty("highlight", federatedQueryOptions.highlight());
        }
        if (federatedQueryOptions.passagesFields() != null) {
            contentJson.addProperty("passages.fields", StringUtils.join(federatedQueryOptions.passagesFields(), ","));
        }
        if (federatedQueryOptions.passagesCount() != null) {
            contentJson.addProperty("passages.count", federatedQueryOptions.passagesCount());
        }
        if (federatedQueryOptions.passagesCharacters() != null) {
            contentJson.addProperty("passages.characters", federatedQueryOptions.passagesCharacters());
        }
        if (federatedQueryOptions.deduplicate() != null) {
            contentJson.addProperty("deduplicate", federatedQueryOptions.deduplicate());
        }
        if (federatedQueryOptions.deduplicateField() != null) {
            contentJson.addProperty("deduplicate.field", federatedQueryOptions.deduplicateField());
        }
        if (federatedQueryOptions.collectionIds() != null) {
            contentJson.addProperty("collection_ids", StringUtils.join(federatedQueryOptions.collectionIds(), ","));
        }
        if (federatedQueryOptions.similar() != null) {
            contentJson.addProperty("similar", federatedQueryOptions.similar());
        }
        if (federatedQueryOptions.similarDocumentIds() != null) {
            contentJson.addProperty("similar.document_ids", StringUtils.join(federatedQueryOptions.similarDocumentIds(), ","));
        }
        if (federatedQueryOptions.similarFields() != null) {
            contentJson.addProperty("similar.fields", StringUtils.join(federatedQueryOptions.similarFields(), ","));
        }
        if (federatedQueryOptions.bias() != null) {
            contentJson.addProperty("bias", federatedQueryOptions.bias());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(QueryResponse.class));
    }

    public ServiceCall<QueryNoticesResponse> federatedQueryNotices(FederatedQueryNoticesOptions federatedQueryNoticesOptions) {
        Validator.notNull(federatedQueryNoticesOptions, "federatedQueryNoticesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "notices"};
        String[] pathParameters = new String[]{federatedQueryNoticesOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        builder.query("collection_ids", RequestUtils.join(federatedQueryNoticesOptions.collectionIds(), ","));
        if (federatedQueryNoticesOptions.filter() != null) {
            builder.query("filter", federatedQueryNoticesOptions.filter());
        }
        if (federatedQueryNoticesOptions.query() != null) {
            builder.query("query", federatedQueryNoticesOptions.query());
        }
        if (federatedQueryNoticesOptions.naturalLanguageQuery() != null) {
            builder.query("natural_language_query", federatedQueryNoticesOptions.naturalLanguageQuery());
        }
        if (federatedQueryNoticesOptions.aggregation() != null) {
            builder.query("aggregation", federatedQueryNoticesOptions.aggregation());
        }
        if (federatedQueryNoticesOptions.count() != null) {
            builder.query("count", String.valueOf(federatedQueryNoticesOptions.count()));
        }
        if (federatedQueryNoticesOptions.returnFields() != null) {
            builder.query("return", RequestUtils.join(federatedQueryNoticesOptions.returnFields(), ","));
        }
        if (federatedQueryNoticesOptions.offset() != null) {
            builder.query("offset", String.valueOf(federatedQueryNoticesOptions.offset()));
        }
        if (federatedQueryNoticesOptions.sort() != null) {
            builder.query("sort", RequestUtils.join(federatedQueryNoticesOptions.sort(), ","));
        }
        if (federatedQueryNoticesOptions.highlight() != null) {
            builder.query("highlight", String.valueOf(federatedQueryNoticesOptions.highlight()));
        }
        if (federatedQueryNoticesOptions.deduplicateField() != null) {
            builder.query("deduplicate.field", federatedQueryNoticesOptions.deduplicateField());
        }
        if (federatedQueryNoticesOptions.similar() != null) {
            builder.query("similar", String.valueOf(federatedQueryNoticesOptions.similar()));
        }
        if (federatedQueryNoticesOptions.similarDocumentIds() != null) {
            builder.query("similar.document_ids", RequestUtils.join(federatedQueryNoticesOptions.similarDocumentIds(), ","));
        }
        if (federatedQueryNoticesOptions.similarFields() != null) {
            builder.query("similar.fields", RequestUtils.join(federatedQueryNoticesOptions.similarFields(), ","));
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(QueryNoticesResponse.class));
    }

    public ServiceCall<QueryResponse> query(QueryOptions queryOptions) {
        Validator.notNull(queryOptions, "queryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "query"};
        String[] pathParameters = new String[]{queryOptions.environmentId(), queryOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        if (queryOptions.loggingOptOut() != null) {
            builder.header("X-Watson-Logging-Opt-Out", queryOptions.loggingOptOut());
        }
        JsonObject contentJson = new JsonObject();
        if (queryOptions.filter() != null) {
            contentJson.addProperty("filter", queryOptions.filter());
        }
        if (queryOptions.query() != null) {
            contentJson.addProperty("query", queryOptions.query());
        }
        if (queryOptions.naturalLanguageQuery() != null) {
            contentJson.addProperty("natural_language_query", queryOptions.naturalLanguageQuery());
        }
        if (queryOptions.passages() != null) {
            contentJson.addProperty("passages", queryOptions.passages());
        }
        if (queryOptions.aggregation() != null) {
            contentJson.addProperty("aggregation", queryOptions.aggregation());
        }
        if (queryOptions.count() != null) {
            contentJson.addProperty("count", queryOptions.count());
        }
        if (queryOptions.returnFields() != null) {
            contentJson.addProperty("return", StringUtils.join(queryOptions.returnFields(), ","));
        }
        if (queryOptions.offset() != null) {
            contentJson.addProperty("offset", queryOptions.offset());
        }
        if (queryOptions.sort() != null) {
            contentJson.addProperty("sort", StringUtils.join(queryOptions.sort(), ","));
        }
        if (queryOptions.highlight() != null) {
            contentJson.addProperty("highlight", queryOptions.highlight());
        }
        if (queryOptions.passagesFields() != null) {
            contentJson.addProperty("passages.fields", StringUtils.join(queryOptions.passagesFields(), ","));
        }
        if (queryOptions.passagesCount() != null) {
            contentJson.addProperty("passages.count", queryOptions.passagesCount());
        }
        if (queryOptions.passagesCharacters() != null) {
            contentJson.addProperty("passages.characters", queryOptions.passagesCharacters());
        }
        if (queryOptions.deduplicate() != null) {
            contentJson.addProperty("deduplicate", queryOptions.deduplicate());
        }
        if (queryOptions.deduplicateField() != null) {
            contentJson.addProperty("deduplicate.field", queryOptions.deduplicateField());
        }
        if (queryOptions.collectionIds() != null) {
            contentJson.addProperty("collection_ids", StringUtils.join(queryOptions.collectionIds(), ","));
        }
        if (queryOptions.similar() != null) {
            contentJson.addProperty("similar", queryOptions.similar());
        }
        if (queryOptions.similarDocumentIds() != null) {
            contentJson.addProperty("similar.document_ids", StringUtils.join(queryOptions.similarDocumentIds(), ","));
        }
        if (queryOptions.similarFields() != null) {
            contentJson.addProperty("similar.fields", StringUtils.join(queryOptions.similarFields(), ","));
        }
        if (queryOptions.bias() != null) {
            contentJson.addProperty("bias", queryOptions.bias());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(QueryResponse.class));
    }

    public ServiceCall<QueryEntitiesResponse> queryEntities(QueryEntitiesOptions queryEntitiesOptions) {
        Validator.notNull(queryEntitiesOptions, "queryEntitiesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "query_entities"};
        String[] pathParameters = new String[]{queryEntitiesOptions.environmentId(), queryEntitiesOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (queryEntitiesOptions.feature() != null) {
            contentJson.addProperty("feature", queryEntitiesOptions.feature());
        }
        if (queryEntitiesOptions.entity() != null) {
            contentJson.add("entity", GsonSingleton.getGson().toJsonTree(queryEntitiesOptions.entity()));
        }
        if (queryEntitiesOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree(queryEntitiesOptions.context()));
        }
        if (queryEntitiesOptions.count() != null) {
            contentJson.addProperty("count", queryEntitiesOptions.count());
        }
        if (queryEntitiesOptions.evidenceCount() != null) {
            contentJson.addProperty("evidence_count", queryEntitiesOptions.evidenceCount());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(QueryEntitiesResponse.class));
    }

    public ServiceCall<QueryNoticesResponse> queryNotices(QueryNoticesOptions queryNoticesOptions) {
        Validator.notNull(queryNoticesOptions, "queryNoticesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "notices"};
        String[] pathParameters = new String[]{queryNoticesOptions.environmentId(), queryNoticesOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        if (queryNoticesOptions.filter() != null) {
            builder.query("filter", queryNoticesOptions.filter());
        }
        if (queryNoticesOptions.query() != null) {
            builder.query("query", queryNoticesOptions.query());
        }
        if (queryNoticesOptions.naturalLanguageQuery() != null) {
            builder.query("natural_language_query", queryNoticesOptions.naturalLanguageQuery());
        }
        if (queryNoticesOptions.passages() != null) {
            builder.query("passages", String.valueOf(queryNoticesOptions.passages()));
        }
        if (queryNoticesOptions.aggregation() != null) {
            builder.query("aggregation", queryNoticesOptions.aggregation());
        }
        if (queryNoticesOptions.count() != null) {
            builder.query("count", String.valueOf(queryNoticesOptions.count()));
        }
        if (queryNoticesOptions.returnFields() != null) {
            builder.query("return", RequestUtils.join(queryNoticesOptions.returnFields(), ","));
        }
        if (queryNoticesOptions.offset() != null) {
            builder.query("offset", String.valueOf(queryNoticesOptions.offset()));
        }
        if (queryNoticesOptions.sort() != null) {
            builder.query("sort", RequestUtils.join(queryNoticesOptions.sort(), ","));
        }
        if (queryNoticesOptions.highlight() != null) {
            builder.query("highlight", String.valueOf(queryNoticesOptions.highlight()));
        }
        if (queryNoticesOptions.passagesFields() != null) {
            builder.query("passages.fields", RequestUtils.join(queryNoticesOptions.passagesFields(), ","));
        }
        if (queryNoticesOptions.passagesCount() != null) {
            builder.query("passages.count", String.valueOf(queryNoticesOptions.passagesCount()));
        }
        if (queryNoticesOptions.passagesCharacters() != null) {
            builder.query("passages.characters", String.valueOf(queryNoticesOptions.passagesCharacters()));
        }
        if (queryNoticesOptions.deduplicateField() != null) {
            builder.query("deduplicate.field", queryNoticesOptions.deduplicateField());
        }
        if (queryNoticesOptions.similar() != null) {
            builder.query("similar", String.valueOf(queryNoticesOptions.similar()));
        }
        if (queryNoticesOptions.similarDocumentIds() != null) {
            builder.query("similar.document_ids", RequestUtils.join(queryNoticesOptions.similarDocumentIds(), ","));
        }
        if (queryNoticesOptions.similarFields() != null) {
            builder.query("similar.fields", RequestUtils.join(queryNoticesOptions.similarFields(), ","));
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(QueryNoticesResponse.class));
    }

    public ServiceCall<QueryRelationsResponse> queryRelations(QueryRelationsOptions queryRelationsOptions) {
        Validator.notNull(queryRelationsOptions, "queryRelationsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "query_relations"};
        String[] pathParameters = new String[]{queryRelationsOptions.environmentId(), queryRelationsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (queryRelationsOptions.entities() != null) {
            contentJson.add("entities", GsonSingleton.getGson().toJsonTree(queryRelationsOptions.entities()));
        }
        if (queryRelationsOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree(queryRelationsOptions.context()));
        }
        if (queryRelationsOptions.sort() != null) {
            contentJson.addProperty("sort", queryRelationsOptions.sort());
        }
        if (queryRelationsOptions.filter() != null) {
            contentJson.add("filter", GsonSingleton.getGson().toJsonTree(queryRelationsOptions.filter()));
        }
        if (queryRelationsOptions.count() != null) {
            contentJson.addProperty("count", queryRelationsOptions.count());
        }
        if (queryRelationsOptions.evidenceCount() != null) {
            contentJson.addProperty("evidence_count", queryRelationsOptions.evidenceCount());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(QueryRelationsResponse.class));
    }

    public ServiceCall<TrainingQuery> addTrainingData(AddTrainingDataOptions addTrainingDataOptions) {
        Validator.notNull(addTrainingDataOptions, "addTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{addTrainingDataOptions.environmentId(), addTrainingDataOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (addTrainingDataOptions.naturalLanguageQuery() != null) {
            contentJson.addProperty("natural_language_query", addTrainingDataOptions.naturalLanguageQuery());
        }
        if (addTrainingDataOptions.filter() != null) {
            contentJson.addProperty("filter", addTrainingDataOptions.filter());
        }
        if (addTrainingDataOptions.examples() != null) {
            contentJson.add("examples", GsonSingleton.getGson().toJsonTree(addTrainingDataOptions.examples()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TrainingQuery.class));
    }

    public ServiceCall<TrainingExample> createTrainingExample(CreateTrainingExampleOptions createTrainingExampleOptions) {
        Validator.notNull(createTrainingExampleOptions, "createTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{createTrainingExampleOptions.environmentId(), createTrainingExampleOptions.collectionId(), createTrainingExampleOptions.queryId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (createTrainingExampleOptions.documentId() != null) {
            contentJson.addProperty("document_id", createTrainingExampleOptions.documentId());
        }
        if (createTrainingExampleOptions.crossReference() != null) {
            contentJson.addProperty("cross_reference", createTrainingExampleOptions.crossReference());
        }
        if (createTrainingExampleOptions.relevance() != null) {
            contentJson.addProperty("relevance", createTrainingExampleOptions.relevance());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TrainingExample.class));
    }

    public ServiceCall<Void> deleteAllTrainingData(DeleteAllTrainingDataOptions deleteAllTrainingDataOptions) {
        Validator.notNull(deleteAllTrainingDataOptions, "deleteAllTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{deleteAllTrainingDataOptions.environmentId(), deleteAllTrainingDataOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteTrainingData(DeleteTrainingDataOptions deleteTrainingDataOptions) {
        Validator.notNull(deleteTrainingDataOptions, "deleteTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{deleteTrainingDataOptions.environmentId(), deleteTrainingDataOptions.collectionId(), deleteTrainingDataOptions.queryId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteTrainingExample(DeleteTrainingExampleOptions deleteTrainingExampleOptions) {
        Validator.notNull(deleteTrainingExampleOptions, "deleteTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{deleteTrainingExampleOptions.environmentId(), deleteTrainingExampleOptions.collectionId(), deleteTrainingExampleOptions.queryId(), deleteTrainingExampleOptions.exampleId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<TrainingQuery> getTrainingData(GetTrainingDataOptions getTrainingDataOptions) {
        Validator.notNull(getTrainingDataOptions, "getTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{getTrainingDataOptions.environmentId(), getTrainingDataOptions.collectionId(), getTrainingDataOptions.queryId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TrainingQuery.class));
    }

    public ServiceCall<TrainingExample> getTrainingExample(GetTrainingExampleOptions getTrainingExampleOptions) {
        Validator.notNull(getTrainingExampleOptions, "getTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{getTrainingExampleOptions.environmentId(), getTrainingExampleOptions.collectionId(), getTrainingExampleOptions.queryId(), getTrainingExampleOptions.exampleId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TrainingExample.class));
    }

    public ServiceCall<TrainingDataSet> listTrainingData(ListTrainingDataOptions listTrainingDataOptions) {
        Validator.notNull(listTrainingDataOptions, "listTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{listTrainingDataOptions.environmentId(), listTrainingDataOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TrainingDataSet.class));
    }

    public ServiceCall<TrainingExampleList> listTrainingExamples(ListTrainingExamplesOptions listTrainingExamplesOptions) {
        Validator.notNull(listTrainingExamplesOptions, "listTrainingExamplesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{listTrainingExamplesOptions.environmentId(), listTrainingExamplesOptions.collectionId(), listTrainingExamplesOptions.queryId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TrainingExampleList.class));
    }

    public ServiceCall<TrainingExample> updateTrainingExample(UpdateTrainingExampleOptions updateTrainingExampleOptions) {
        Validator.notNull(updateTrainingExampleOptions, "updateTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{updateTrainingExampleOptions.environmentId(), updateTrainingExampleOptions.collectionId(), updateTrainingExampleOptions.queryId(), updateTrainingExampleOptions.exampleId()};
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (updateTrainingExampleOptions.crossReference() != null) {
            contentJson.addProperty("cross_reference", updateTrainingExampleOptions.crossReference());
        }
        if (updateTrainingExampleOptions.relevance() != null) {
            contentJson.addProperty("relevance", updateTrainingExampleOptions.relevance());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TrainingExample.class));
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull(deleteUserDataOptions, "deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/user_data"};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        builder.query("customer_id", deleteUserDataOptions.customerId());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<CreateEventResponse> createEvent(CreateEventOptions createEventOptions) {
        Validator.notNull(createEventOptions, "createEventOptions cannot be null");
        String[] pathSegments = new String[]{"v1/events"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("type", createEventOptions.type());
        contentJson.add("data", GsonSingleton.getGson().toJsonTree(createEventOptions.data()));
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(CreateEventResponse.class));
    }

    public ServiceCall<MetricResponse> getMetricsEventRate(GetMetricsEventRateOptions getMetricsEventRateOptions) {
        String[] pathSegments = new String[]{"v1/metrics/event_rate"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (getMetricsEventRateOptions != null) {
            if (getMetricsEventRateOptions.startTime() != null) {
                builder.query("start_time", String.valueOf(getMetricsEventRateOptions.startTime()));
            }
            if (getMetricsEventRateOptions.endTime() != null) {
                builder.query("end_time", String.valueOf(getMetricsEventRateOptions.endTime()));
            }
            if (getMetricsEventRateOptions.resultType() != null) {
                builder.query("result_type", getMetricsEventRateOptions.resultType());
            }
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MetricResponse.class));
    }

    public ServiceCall<MetricResponse> getMetricsEventRate() {
        return this.getMetricsEventRate(null);
    }

    public ServiceCall<MetricResponse> getMetricsQuery(GetMetricsQueryOptions getMetricsQueryOptions) {
        String[] pathSegments = new String[]{"v1/metrics/number_of_queries"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (getMetricsQueryOptions != null) {
            if (getMetricsQueryOptions.startTime() != null) {
                builder.query("start_time", String.valueOf(getMetricsQueryOptions.startTime()));
            }
            if (getMetricsQueryOptions.endTime() != null) {
                builder.query("end_time", String.valueOf(getMetricsQueryOptions.endTime()));
            }
            if (getMetricsQueryOptions.resultType() != null) {
                builder.query("result_type", getMetricsQueryOptions.resultType());
            }
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MetricResponse.class));
    }

    public ServiceCall<MetricResponse> getMetricsQuery() {
        return this.getMetricsQuery(null);
    }

    public ServiceCall<MetricResponse> getMetricsQueryEvent(GetMetricsQueryEventOptions getMetricsQueryEventOptions) {
        String[] pathSegments = new String[]{"v1/metrics/number_of_queries_with_event"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (getMetricsQueryEventOptions != null) {
            if (getMetricsQueryEventOptions.startTime() != null) {
                builder.query("start_time", String.valueOf(getMetricsQueryEventOptions.startTime()));
            }
            if (getMetricsQueryEventOptions.endTime() != null) {
                builder.query("end_time", String.valueOf(getMetricsQueryEventOptions.endTime()));
            }
            if (getMetricsQueryEventOptions.resultType() != null) {
                builder.query("result_type", getMetricsQueryEventOptions.resultType());
            }
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MetricResponse.class));
    }

    public ServiceCall<MetricResponse> getMetricsQueryEvent() {
        return this.getMetricsQueryEvent(null);
    }

    public ServiceCall<MetricResponse> getMetricsQueryNoResults(GetMetricsQueryNoResultsOptions getMetricsQueryNoResultsOptions) {
        String[] pathSegments = new String[]{"v1/metrics/number_of_queries_with_no_search_results"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (getMetricsQueryNoResultsOptions != null) {
            if (getMetricsQueryNoResultsOptions.startTime() != null) {
                builder.query("start_time", String.valueOf(getMetricsQueryNoResultsOptions.startTime()));
            }
            if (getMetricsQueryNoResultsOptions.endTime() != null) {
                builder.query("end_time", String.valueOf(getMetricsQueryNoResultsOptions.endTime()));
            }
            if (getMetricsQueryNoResultsOptions.resultType() != null) {
                builder.query("result_type", getMetricsQueryNoResultsOptions.resultType());
            }
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MetricResponse.class));
    }

    public ServiceCall<MetricResponse> getMetricsQueryNoResults() {
        return this.getMetricsQueryNoResults(null);
    }

    public ServiceCall<MetricTokenResponse> getMetricsQueryTokenEvent(GetMetricsQueryTokenEventOptions getMetricsQueryTokenEventOptions) {
        String[] pathSegments = new String[]{"v1/metrics/top_query_tokens_with_event_rate"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (getMetricsQueryTokenEventOptions != null && getMetricsQueryTokenEventOptions.count() != null) {
            builder.query("count", String.valueOf(getMetricsQueryTokenEventOptions.count()));
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MetricTokenResponse.class));
    }

    public ServiceCall<MetricTokenResponse> getMetricsQueryTokenEvent() {
        return this.getMetricsQueryTokenEvent(null);
    }

    public ServiceCall<LogQueryResponse> queryLog(QueryLogOptions queryLogOptions) {
        String[] pathSegments = new String[]{"v1/logs"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (queryLogOptions != null) {
            if (queryLogOptions.filter() != null) {
                builder.query("filter", queryLogOptions.filter());
            }
            if (queryLogOptions.query() != null) {
                builder.query("query", queryLogOptions.query());
            }
            if (queryLogOptions.count() != null) {
                builder.query("count", String.valueOf(queryLogOptions.count()));
            }
            if (queryLogOptions.offset() != null) {
                builder.query("offset", String.valueOf(queryLogOptions.offset()));
            }
            if (queryLogOptions.sort() != null) {
                builder.query("sort", RequestUtils.join(queryLogOptions.sort(), ","));
            }
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(LogQueryResponse.class));
    }

    public ServiceCall<LogQueryResponse> queryLog() {
        return this.queryLog(null);
    }

    public ServiceCall<Credentials> createCredentials(CreateCredentialsOptions createCredentialsOptions) {
        Validator.notNull(createCredentialsOptions, "createCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{createCredentialsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (createCredentialsOptions.sourceType() != null) {
            contentJson.addProperty("source_type", createCredentialsOptions.sourceType());
        }
        if (createCredentialsOptions.credentialDetails() != null) {
            contentJson.add("credential_details", GsonSingleton.getGson().toJsonTree(createCredentialsOptions.credentialDetails()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Credentials.class));
    }

    public ServiceCall<Void> deleteCredentials(DeleteCredentialsOptions deleteCredentialsOptions) {
        Validator.notNull(deleteCredentialsOptions, "deleteCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{deleteCredentialsOptions.environmentId(), deleteCredentialsOptions.credentialId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Credentials> getCredentials(GetCredentialsOptions getCredentialsOptions) {
        Validator.notNull(getCredentialsOptions, "getCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{getCredentialsOptions.environmentId(), getCredentialsOptions.credentialId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Credentials.class));
    }

    public ServiceCall<CredentialsList> listCredentials(ListCredentialsOptions listCredentialsOptions) {
        Validator.notNull(listCredentialsOptions, "listCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{listCredentialsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(CredentialsList.class));
    }

    public ServiceCall<Credentials> updateCredentials(UpdateCredentialsOptions updateCredentialsOptions) {
        Validator.notNull(updateCredentialsOptions, "updateCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{updateCredentialsOptions.environmentId(), updateCredentialsOptions.credentialId()};
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (updateCredentialsOptions.sourceType() != null) {
            contentJson.addProperty("source_type", updateCredentialsOptions.sourceType());
        }
        if (updateCredentialsOptions.credentialDetails() != null) {
            contentJson.add("credential_details", GsonSingleton.getGson().toJsonTree(updateCredentialsOptions.credentialDetails()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Credentials.class));
    }
}

