/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateValueOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;
    private List<String> newSynonyms;
    private String valueType;
    private Map newMetadata;
    private List<String> newPatterns;
    private String newValue;

    private UpdateValueOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.entity, "entity cannot be empty");
        Validator.notEmpty(builder.value, "value cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.newSynonyms = builder.newSynonyms;
        this.valueType = builder.valueType;
        this.newMetadata = builder.newMetadata;
        this.newPatterns = builder.newPatterns;
        this.newValue = builder.newValue;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public List<String> newSynonyms() {
        return this.newSynonyms;
    }

    public String valueType() {
        return this.valueType;
    }

    public Map newMetadata() {
        return this.newMetadata;
    }

    public List<String> newPatterns() {
        return this.newPatterns;
    }

    public String newValue() {
        return this.newValue;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private List<String> newSynonyms;
        private String valueType;
        private Map newMetadata;
        private List<String> newPatterns;
        private String newValue;

        private Builder(UpdateValueOptions updateValueOptions) {
            this.workspaceId = updateValueOptions.workspaceId;
            this.entity = updateValueOptions.entity;
            this.value = updateValueOptions.value;
            this.newSynonyms = updateValueOptions.newSynonyms;
            this.valueType = updateValueOptions.valueType;
            this.newMetadata = updateValueOptions.newMetadata;
            this.newPatterns = updateValueOptions.newPatterns;
            this.newValue = updateValueOptions.newValue;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public UpdateValueOptions build() {
            return new UpdateValueOptions(this);
        }

        public Builder addSynonym(String synonym) {
            Validator.notNull(synonym, "synonym cannot be null");
            if (this.newSynonyms == null) {
                this.newSynonyms = new ArrayList<String>();
            }
            this.newSynonyms.add(synonym);
            return this;
        }

        public Builder addPattern(String pattern) {
            Validator.notNull(pattern, "pattern cannot be null");
            if (this.newPatterns == null) {
                this.newPatterns = new ArrayList<String>();
            }
            this.newPatterns.add(pattern);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder newSynonyms(List<String> newSynonyms) {
            this.newSynonyms = newSynonyms;
            return this;
        }

        public Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder newMetadata(Map newMetadata) {
            this.newMetadata = newMetadata;
            return this;
        }

        public Builder newPatterns(List<String> newPatterns) {
            this.newPatterns = newPatterns;
            return this;
        }

        public Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }
    }

    public static interface ValueType {
        public static final String SYNONYMS = "synonyms";
        public static final String PATTERNS = "patterns";
    }
}

