/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetIntentOptions
extends GenericModel {
    private String workspaceId;
    private String intent;
    private Boolean export;
    private Boolean includeAudit;

    private GetIntentOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.intent, "intent cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.export = builder.export;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public Boolean export() {
        return this.export;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private Boolean export;
        private Boolean includeAudit;

        private Builder(GetIntentOptions getIntentOptions) {
            this.workspaceId = getIntentOptions.workspaceId;
            this.intent = getIntentOptions.intent;
            this.export = getIntentOptions.export;
            this.includeAudit = getIntentOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent) {
            this.workspaceId = workspaceId;
            this.intent = intent;
        }

        public GetIntentOptions build() {
            return new GetIntentOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder export(Boolean export) {
            this.export = export;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

