/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetEntityOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private Boolean export;
    private Boolean includeAudit;

    private GetEntityOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.entity, "entity cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.export = builder.export;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public Boolean export() {
        return this.export;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private Boolean export;
        private Boolean includeAudit;

        private Builder(GetEntityOptions getEntityOptions) {
            this.workspaceId = getEntityOptions.workspaceId;
            this.entity = getEntityOptions.entity;
            this.export = getEntityOptions.export;
            this.includeAudit = getEntityOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity) {
            this.workspaceId = workspaceId;
            this.entity = entity;
        }

        public GetEntityOptions build() {
            return new GetEntityOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder export(Boolean export) {
            this.export = export;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

