/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetDialogNodeOptions
extends GenericModel {
    private String workspaceId;
    private String dialogNode;
    private Boolean includeAudit;

    private GetDialogNodeOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.dialogNode, "dialogNode cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.dialogNode = builder.dialogNode;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String dialogNode() {
        return this.dialogNode;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String dialogNode;
        private Boolean includeAudit;

        private Builder(GetDialogNodeOptions getDialogNodeOptions) {
            this.workspaceId = getDialogNodeOptions.workspaceId;
            this.dialogNode = getDialogNodeOptions.dialogNode;
            this.includeAudit = getDialogNodeOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String dialogNode) {
            this.workspaceId = workspaceId;
            this.dialogNode = dialogNode;
        }

        public GetDialogNodeOptions build() {
            return new GetDialogNodeOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dialogNode(String dialogNode) {
            this.dialogNode = dialogNode;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

