/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.conversation.v1.model.CreateCounterexample;
import com.ibm.watson.developer_cloud.conversation.v1.model.CreateDialogNode;
import com.ibm.watson.developer_cloud.conversation.v1.model.CreateEntity;
import com.ibm.watson.developer_cloud.conversation.v1.model.CreateIntent;
import com.ibm.watson.developer_cloud.conversation.v1.model.WorkspaceSystemSettings;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateWorkspaceOptions
extends GenericModel {
    private String name;
    private String description;
    private String language;
    private List<CreateIntent> intents;
    private List<CreateEntity> entities;
    private List<CreateDialogNode> dialogNodes;
    private List<CreateCounterexample> counterexamples;
    private Map metadata;
    private Boolean learningOptOut;
    private WorkspaceSystemSettings systemSettings;

    private CreateWorkspaceOptions(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.dialogNodes = builder.dialogNodes;
        this.counterexamples = builder.counterexamples;
        this.metadata = builder.metadata;
        this.learningOptOut = builder.learningOptOut;
        this.systemSettings = builder.systemSettings;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String language() {
        return this.language;
    }

    public List<CreateIntent> intents() {
        return this.intents;
    }

    public List<CreateEntity> entities() {
        return this.entities;
    }

    public List<CreateDialogNode> dialogNodes() {
        return this.dialogNodes;
    }

    public List<CreateCounterexample> counterexamples() {
        return this.counterexamples;
    }

    public Map metadata() {
        return this.metadata;
    }

    public Boolean learningOptOut() {
        return this.learningOptOut;
    }

    public WorkspaceSystemSettings systemSettings() {
        return this.systemSettings;
    }

    public static class Builder {
        private String name;
        private String description;
        private String language;
        private List<CreateIntent> intents;
        private List<CreateEntity> entities;
        private List<CreateDialogNode> dialogNodes;
        private List<CreateCounterexample> counterexamples;
        private Map metadata;
        private Boolean learningOptOut;
        private WorkspaceSystemSettings systemSettings;

        private Builder(CreateWorkspaceOptions createWorkspaceOptions) {
            this.name = createWorkspaceOptions.name;
            this.description = createWorkspaceOptions.description;
            this.language = createWorkspaceOptions.language;
            this.intents = createWorkspaceOptions.intents;
            this.entities = createWorkspaceOptions.entities;
            this.dialogNodes = createWorkspaceOptions.dialogNodes;
            this.counterexamples = createWorkspaceOptions.counterexamples;
            this.metadata = createWorkspaceOptions.metadata;
            this.learningOptOut = createWorkspaceOptions.learningOptOut;
            this.systemSettings = createWorkspaceOptions.systemSettings;
        }

        public Builder() {
        }

        public CreateWorkspaceOptions build() {
            return new CreateWorkspaceOptions(this);
        }

        public Builder addIntent(CreateIntent intent) {
            Validator.notNull(intent, "intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<CreateIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(CreateEntity entity) {
            Validator.notNull(entity, "entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<CreateEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder addDialogNode(CreateDialogNode dialogNode) {
            Validator.notNull(dialogNode, "dialogNode cannot be null");
            if (this.dialogNodes == null) {
                this.dialogNodes = new ArrayList<CreateDialogNode>();
            }
            this.dialogNodes.add(dialogNode);
            return this;
        }

        public Builder addCounterexample(CreateCounterexample counterexample) {
            Validator.notNull(counterexample, "counterexample cannot be null");
            if (this.counterexamples == null) {
                this.counterexamples = new ArrayList<CreateCounterexample>();
            }
            this.counterexamples.add(counterexample);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder intents(List<CreateIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<CreateEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder dialogNodes(List<CreateDialogNode> dialogNodes) {
            this.dialogNodes = dialogNodes;
            return this;
        }

        public Builder counterexamples(List<CreateCounterexample> counterexamples) {
            this.counterexamples = counterexamples;
            return this;
        }

        public Builder metadata(Map metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder learningOptOut(Boolean learningOptOut) {
            this.learningOptOut = learningOptOut;
            return this;
        }

        public Builder systemSettings(WorkspaceSystemSettings systemSettings) {
            this.systemSettings = systemSettings;
            return this;
        }
    }
}

