/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.conversation.v1.model.CreateExample;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateIntent
extends GenericModel {
    private String intent;
    private String description;
    private List<CreateExample> examples;

    private CreateIntent(Builder builder) {
        Validator.notNull(builder.intent, "intent cannot be null");
        this.intent = builder.intent;
        this.description = builder.description;
        this.examples = builder.examples;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String intent() {
        return this.intent;
    }

    public String description() {
        return this.description;
    }

    public List<CreateExample> examples() {
        return this.examples;
    }

    public static class Builder {
        private String intent;
        private String description;
        private List<CreateExample> examples;

        private Builder(CreateIntent createIntent) {
            this.intent = createIntent.intent;
            this.description = createIntent.description;
            this.examples = createIntent.examples;
        }

        public Builder() {
        }

        public Builder(String intent) {
            this.intent = intent;
        }

        public CreateIntent build() {
            return new CreateIntent(this);
        }

        public Builder addExample(CreateExample example) {
            Validator.notNull(example, "example cannot be null");
            if (this.examples == null) {
                this.examples = new ArrayList<CreateExample>();
            }
            this.examples.add(example);
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder examples(List<CreateExample> examples) {
            this.examples = examples;
            return this;
        }
    }
}

