/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.assistant.v2.model.MessageInputOptions;
import com.ibm.watson.developer_cloud.assistant.v2.model.RuntimeEntity;
import com.ibm.watson.developer_cloud.assistant.v2.model.RuntimeIntent;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class MessageInput
extends GenericModel {
    @SerializedName(value="message_type")
    private String messageType;
    private String text;
    private MessageInputOptions options;
    private List<RuntimeIntent> intents;
    private List<RuntimeEntity> entities;
    @SerializedName(value="suggestion_id")
    private String suggestionId;

    private MessageInput(Builder builder) {
        this.messageType = builder.messageType;
        this.text = builder.text;
        this.options = builder.options;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.suggestionId = builder.suggestionId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String messageType() {
        return this.messageType;
    }

    public String text() {
        return this.text;
    }

    public MessageInputOptions options() {
        return this.options;
    }

    public List<RuntimeIntent> intents() {
        return this.intents;
    }

    public List<RuntimeEntity> entities() {
        return this.entities;
    }

    public String suggestionId() {
        return this.suggestionId;
    }

    public static class Builder {
        private String messageType;
        private String text;
        private MessageInputOptions options;
        private List<RuntimeIntent> intents;
        private List<RuntimeEntity> entities;
        private String suggestionId;

        private Builder(MessageInput messageInput) {
            this.messageType = messageInput.messageType;
            this.text = messageInput.text;
            this.options = messageInput.options;
            this.intents = messageInput.intents;
            this.entities = messageInput.entities;
            this.suggestionId = messageInput.suggestionId;
        }

        public Builder() {
        }

        public MessageInput build() {
            return new MessageInput(this);
        }

        public Builder addIntent(RuntimeIntent intent) {
            Validator.notNull(intent, "intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<RuntimeIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(RuntimeEntity entity) {
            Validator.notNull(entity, "entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<RuntimeEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder options(MessageInputOptions options) {
            this.options = options;
            return this;
        }

        public Builder intents(List<RuntimeIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<RuntimeEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder suggestionId(String suggestionId) {
            this.suggestionId = suggestionId;
            return this;
        }
    }

    public static interface MessageType {
        public static final String TEXT = "text";
    }
}

