/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v2.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class DeleteSessionOptions
extends GenericModel {
    private String assistantId;
    private String sessionId;

    private DeleteSessionOptions(Builder builder) {
        Validator.notEmpty(builder.assistantId, "assistantId cannot be empty");
        Validator.notEmpty(builder.sessionId, "sessionId cannot be empty");
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public static class Builder {
        private String assistantId;
        private String sessionId;

        private Builder(DeleteSessionOptions deleteSessionOptions) {
            this.assistantId = deleteSessionOptions.assistantId;
            this.sessionId = deleteSessionOptions.sessionId;
        }

        public Builder() {
        }

        public Builder(String assistantId, String sessionId) {
            this.assistantId = assistantId;
            this.sessionId = sessionId;
        }

        public DeleteSessionOptions build() {
            return new DeleteSessionOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }
    }
}

