/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class ListExamplesOptions
extends GenericModel {
    private String workspaceId;
    private String intent;
    private Long pageLimit;
    private Boolean includeCount;
    private String sort;
    private String cursor;
    private Boolean includeAudit;

    private ListExamplesOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.intent, "intent cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.pageLimit = builder.pageLimit;
        this.includeCount = builder.includeCount;
        this.sort = builder.sort;
        this.cursor = builder.cursor;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public Boolean includeCount() {
        return this.includeCount;
    }

    public String sort() {
        return this.sort;
    }

    public String cursor() {
        return this.cursor;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private Long pageLimit;
        private Boolean includeCount;
        private String sort;
        private String cursor;
        private Boolean includeAudit;

        private Builder(ListExamplesOptions listExamplesOptions) {
            this.workspaceId = listExamplesOptions.workspaceId;
            this.intent = listExamplesOptions.intent;
            this.pageLimit = listExamplesOptions.pageLimit;
            this.includeCount = listExamplesOptions.includeCount;
            this.sort = listExamplesOptions.sort;
            this.cursor = listExamplesOptions.cursor;
            this.includeAudit = listExamplesOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent) {
            this.workspaceId = workspaceId;
            this.intent = intent;
        }

        public ListExamplesOptions build() {
            return new ListExamplesOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder includeCount(Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }

    public static interface Sort {
        public static final String TEXT = "text";
        public static final String UPDATED = "updated";
    }
}

