/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateValue;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateEntity
extends GenericModel {
    private String entity;
    private String description;
    private Map metadata;
    private List<CreateValue> values;
    @SerializedName(value="fuzzy_match")
    private Boolean fuzzyMatch;

    private CreateEntity(Builder builder) {
        Validator.notNull(builder.entity, "entity cannot be null");
        this.entity = builder.entity;
        this.description = builder.description;
        this.metadata = builder.metadata;
        this.values = builder.values;
        this.fuzzyMatch = builder.fuzzyMatch;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String entity() {
        return this.entity;
    }

    public String description() {
        return this.description;
    }

    public Map metadata() {
        return this.metadata;
    }

    public List<CreateValue> values() {
        return this.values;
    }

    public Boolean fuzzyMatch() {
        return this.fuzzyMatch;
    }

    public static class Builder {
        private String entity;
        private String description;
        private Map metadata;
        private List<CreateValue> values;
        private Boolean fuzzyMatch;

        private Builder(CreateEntity createEntity) {
            this.entity = createEntity.entity;
            this.description = createEntity.description;
            this.metadata = createEntity.metadata;
            this.values = createEntity.values;
            this.fuzzyMatch = createEntity.fuzzyMatch;
        }

        public Builder() {
        }

        public Builder(String entity) {
            this.entity = entity;
        }

        public CreateEntity build() {
            return new CreateEntity(this);
        }

        public Builder addValue(CreateValue value) {
            Validator.notNull(value, "value cannot be null");
            if (this.values == null) {
                this.values = new ArrayList<CreateValue>();
            }
            this.values.add(value);
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder metadata(Map metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder values(List<CreateValue> values) {
            this.values = values;
            return this;
        }

        public Builder fuzzyMatch(Boolean fuzzyMatch) {
            this.fuzzyMatch = fuzzyMatch;
            return this;
        }
    }
}

