/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.assistant.v1.model.DialogNodeAction;
import com.ibm.watson.developer_cloud.assistant.v1.model.DialogNodeNextStep;
import com.ibm.watson.developer_cloud.assistant.v1.model.DialogNodeOutput;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateDialogNode
extends GenericModel {
    @SerializedName(value="dialog_node")
    private String dialogNode;
    private String description;
    private String conditions;
    private String parent;
    @SerializedName(value="previous_sibling")
    private String previousSibling;
    private DialogNodeOutput output;
    private Map context;
    private Map metadata;
    @SerializedName(value="next_step")
    private DialogNodeNextStep nextStep;
    private List<DialogNodeAction> actions;
    private String title;
    @SerializedName(value="type")
    private String nodeType;
    @SerializedName(value="event_name")
    private String eventName;
    private String variable;
    @SerializedName(value="digress_in")
    private String digressIn;
    @SerializedName(value="digress_out")
    private String digressOut;
    @SerializedName(value="digress_out_slots")
    private String digressOutSlots;
    @SerializedName(value="user_label")
    private String userLabel;

    private CreateDialogNode(Builder builder) {
        Validator.notNull(builder.dialogNode, "dialogNode cannot be null");
        this.dialogNode = builder.dialogNode;
        this.description = builder.description;
        this.conditions = builder.conditions;
        this.parent = builder.parent;
        this.previousSibling = builder.previousSibling;
        this.output = builder.output;
        this.context = builder.context;
        this.metadata = builder.metadata;
        this.nextStep = builder.nextStep;
        this.actions = builder.actions;
        this.title = builder.title;
        this.nodeType = builder.nodeType;
        this.eventName = builder.eventName;
        this.variable = builder.variable;
        this.digressIn = builder.digressIn;
        this.digressOut = builder.digressOut;
        this.digressOutSlots = builder.digressOutSlots;
        this.userLabel = builder.userLabel;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String dialogNode() {
        return this.dialogNode;
    }

    public String description() {
        return this.description;
    }

    public String conditions() {
        return this.conditions;
    }

    public String parent() {
        return this.parent;
    }

    public String previousSibling() {
        return this.previousSibling;
    }

    public DialogNodeOutput output() {
        return this.output;
    }

    public Map context() {
        return this.context;
    }

    public Map metadata() {
        return this.metadata;
    }

    public DialogNodeNextStep nextStep() {
        return this.nextStep;
    }

    public List<DialogNodeAction> actions() {
        return this.actions;
    }

    public String title() {
        return this.title;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public String eventName() {
        return this.eventName;
    }

    public String variable() {
        return this.variable;
    }

    public String digressIn() {
        return this.digressIn;
    }

    public String digressOut() {
        return this.digressOut;
    }

    public String digressOutSlots() {
        return this.digressOutSlots;
    }

    public String userLabel() {
        return this.userLabel;
    }

    public static class Builder {
        private String dialogNode;
        private String description;
        private String conditions;
        private String parent;
        private String previousSibling;
        private DialogNodeOutput output;
        private Map context;
        private Map metadata;
        private DialogNodeNextStep nextStep;
        private List<DialogNodeAction> actions;
        private String title;
        private String nodeType;
        private String eventName;
        private String variable;
        private String digressIn;
        private String digressOut;
        private String digressOutSlots;
        private String userLabel;

        private Builder(CreateDialogNode createDialogNode) {
            this.dialogNode = createDialogNode.dialogNode;
            this.description = createDialogNode.description;
            this.conditions = createDialogNode.conditions;
            this.parent = createDialogNode.parent;
            this.previousSibling = createDialogNode.previousSibling;
            this.output = createDialogNode.output;
            this.context = createDialogNode.context;
            this.metadata = createDialogNode.metadata;
            this.nextStep = createDialogNode.nextStep;
            this.actions = createDialogNode.actions;
            this.title = createDialogNode.title;
            this.nodeType = createDialogNode.nodeType;
            this.eventName = createDialogNode.eventName;
            this.variable = createDialogNode.variable;
            this.digressIn = createDialogNode.digressIn;
            this.digressOut = createDialogNode.digressOut;
            this.digressOutSlots = createDialogNode.digressOutSlots;
            this.userLabel = createDialogNode.userLabel;
        }

        public Builder() {
        }

        public Builder(String dialogNode) {
            this.dialogNode = dialogNode;
        }

        public CreateDialogNode build() {
            return new CreateDialogNode(this);
        }

        public Builder addActions(DialogNodeAction actions) {
            Validator.notNull(actions, "actions cannot be null");
            if (this.actions == null) {
                this.actions = new ArrayList<DialogNodeAction>();
            }
            this.actions.add(actions);
            return this;
        }

        public Builder dialogNode(String dialogNode) {
            this.dialogNode = dialogNode;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder conditions(String conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder previousSibling(String previousSibling) {
            this.previousSibling = previousSibling;
            return this;
        }

        public Builder output(DialogNodeOutput output) {
            this.output = output;
            return this;
        }

        public Builder context(Map context) {
            this.context = context;
            return this;
        }

        public Builder metadata(Map metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder nextStep(DialogNodeNextStep nextStep) {
            this.nextStep = nextStep;
            return this;
        }

        public Builder actions(List<DialogNodeAction> actions) {
            this.actions = actions;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public Builder variable(String variable) {
            this.variable = variable;
            return this;
        }

        public Builder digressIn(String digressIn) {
            this.digressIn = digressIn;
            return this;
        }

        public Builder digressOut(String digressOut) {
            this.digressOut = digressOut;
            return this;
        }

        public Builder digressOutSlots(String digressOutSlots) {
            this.digressOutSlots = digressOutSlots;
            return this;
        }

        public Builder userLabel(String userLabel) {
            this.userLabel = userLabel;
            return this;
        }
    }

    public static interface DigressOutSlots {
        public static final String NOT_ALLOWED = "not_allowed";
        public static final String ALLOW_RETURNING = "allow_returning";
        public static final String ALLOW_ALL = "allow_all";
    }

    public static interface DigressOut {
        public static final String ALLOW_RETURNING = "allow_returning";
        public static final String ALLOW_ALL = "allow_all";
        public static final String ALLOW_ALL_NEVER_RETURN = "allow_all_never_return";
    }

    public static interface DigressIn {
        public static final String NOT_AVAILABLE = "not_available";
        public static final String RETURNS = "returns";
        public static final String DOES_NOT_RETURN = "does_not_return";
    }

    public static interface EventName {
        public static final String FOCUS = "focus";
        public static final String INPUT = "input";
        public static final String FILLED = "filled";
        public static final String VALIDATE = "validate";
        public static final String FILLED_MULTIPLE = "filled_multiple";
        public static final String GENERIC = "generic";
        public static final String NOMATCH = "nomatch";
        public static final String NOMATCH_RESPONSES_DEPLETED = "nomatch_responses_depleted";
        public static final String DIGRESSION_RETURN_PROMPT = "digression_return_prompt";
    }

    public static interface NodeType {
        public static final String STANDARD = "standard";
        public static final String EVENT_HANDLER = "event_handler";
        public static final String FRAME = "frame";
        public static final String SLOT = "slot";
        public static final String RESPONSE_CONDITION = "response_condition";
        public static final String FOLDER = "folder";
    }
}

