/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;

public class ClassifyImagesOptions {
    private File imagesFile;
    private HttpUrl url;
    private List<String> classifierIds;
    private Double threshold;

    private ClassifyImagesOptions(Builder builder) {
        this.imagesFile = builder.imagesFile;
        this.url = builder.url;
        this.classifierIds = builder.classifierIds;
        this.threshold = builder.threshold;
    }

    public File images() {
        return this.imagesFile;
    }

    public HttpUrl url() {
        return this.url;
    }

    public Double threshold() {
        return this.threshold;
    }

    public List<String> classifierIds() {
        return this.classifierIds;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private File imagesFile;
        private HttpUrl url;
        private List<String> classifierIds;
        private Double threshold;

        private Builder(ClassifyImagesOptions options) {
            this();
            this.imagesFile = options.imagesFile;
            this.url = options.url;
            this.classifierIds = new ArrayList<String>(options.classifierIds);
            this.threshold = options.threshold;
        }

        public Builder images(File imagesFile) {
            Validator.notNull(imagesFile, "'imagesFile' cannot be null");
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder url(HttpUrl url) {
            Validator.notNull(url, "'url' cannot be null");
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            return this.url(HttpUrl.parse((String)url));
        }

        public Builder classifierIds(List<String> classifierIds) {
            this.classifierIds = classifierIds;
            return this;
        }

        public Builder classifierIds(String classifierId) {
            if (this.classifierIds == null) {
                this.classifierIds = new ArrayList<String>();
            }
            this.classifierIds.add(classifierId);
            return this;
        }

        public Builder threshold(double threshold) {
            Validator.isTrue(threshold <= 1.0 && threshold >= 0.0, "'threshold' needs to be between 0.0 and 1.0");
            this.threshold = threshold;
            return this;
        }

        public Builder() {
        }

        public ClassifyImagesOptions build() {
            Validator.isTrue(this.url != null || this.imagesFile != null, "url or imagesFile should be specified");
            return new ClassifyImagesOptions(this);
        }
    }
}

