/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import okhttp3.Credentials;

public final class CredentialUtils {
    private static final String ALCHEMY_API = "alchemy_api";
    private static final String APIKEY = "apikey";
    private static final String CREDENTIALS = "credentials";
    private static final Logger log = Logger.getLogger(CredentialUtils.class.getName());
    private static final String PASSWORD = "password";
    private static final String PLAN = "plan";
    private static String services;
    private static final String USERNAME = "username";
    private static final String URL = "url";
    public static final String PLAN_EXPERIMENTAL = "experimental";
    public static final String PLAN_FREE = "free";
    public static final String PLAN_STANDARD = "standard";

    private CredentialUtils() {
    }

    private static String getKeyUsingJNDI(String serviceName) {
        if (!CredentialUtils.isClassAvailable("javax.naming.Context")) {
            log.info("JNDI string lookups is not available.");
            return null;
        }
        try {
            InitialContext context = new InitialContext();
            String lookupName = "watson-developer-cloud/" + serviceName + "/credentials";
            return (String)context.lookup(lookupName);
        }
        catch (Exception e) {
            log.warning("Error during JNDI key lookup: " + e.getMessage());
            return null;
        }
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static JsonObject getVCAPServices() {
        String envServices;
        String string = envServices = services != null ? services : System.getenv("VCAP_SERVICES");
        if (envServices == null) {
            return null;
        }
        JsonObject vcapServices = null;
        try {
            JsonParser parser = new JsonParser();
            vcapServices = (JsonObject)parser.parse(envServices);
        }
        catch (JsonSyntaxException e) {
            log.log(Level.INFO, "Error parsing VCAP_SERVICES", e);
        }
        return vcapServices;
    }

    public static String getAPIKey(String serviceName) {
        return CredentialUtils.getAPIKey(serviceName, null);
    }

    public static String getAPIKey(String serviceName, String plan) {
        if (serviceName == null || serviceName.isEmpty()) {
            return null;
        }
        JsonObject services = CredentialUtils.getVCAPServices();
        if (services == null) {
            return CredentialUtils.getKeyUsingJNDI(serviceName);
        }
        if (serviceName.equalsIgnoreCase(ALCHEMY_API)) {
            JsonObject credentials = CredentialUtils.getCredentialsObject(services, serviceName, plan);
            if (credentials != null && serviceName.equalsIgnoreCase(ALCHEMY_API)) {
                return credentials.get(APIKEY).getAsString();
            }
        } else {
            ServiceCredentials credentials = CredentialUtils.getUserNameAndPassword(serviceName, plan);
            if (credentials != null) {
                return Credentials.basic((String)credentials.getUsername(), (String)credentials.getPassword());
            }
        }
        return null;
    }

    public static ServiceCredentials getUserNameAndPassword(String serviceName) {
        return CredentialUtils.getUserNameAndPassword(serviceName, null);
    }

    public static ServiceCredentials getUserNameAndPassword(String serviceName, String plan) {
        if (serviceName == null || serviceName.isEmpty()) {
            return null;
        }
        JsonObject services = CredentialUtils.getVCAPServices();
        if (services == null) {
            return null;
        }
        JsonObject jsonCredentials = CredentialUtils.getCredentialsObject(services, serviceName, plan);
        if (jsonCredentials != null) {
            String username = null;
            if (jsonCredentials.has(USERNAME)) {
                username = jsonCredentials.get(USERNAME).getAsString();
            }
            String password = null;
            if (jsonCredentials.has(PASSWORD)) {
                password = jsonCredentials.get(PASSWORD).getAsString();
            }
            if (username != null || password != null) {
                return new ServiceCredentials(username, password);
            }
        }
        return null;
    }

    private static JsonObject getCredentialsObject(JsonObject vcapServices, String serviceName, String plan) {
        for (Map.Entry entry : vcapServices.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(serviceName)) continue;
            JsonArray servInstances = vcapServices.getAsJsonArray(key);
            for (JsonElement instance : servInstances) {
                JsonObject service = instance.getAsJsonObject();
                String instancePlan = service.get(PLAN).getAsString();
                if (plan != null && !plan.equalsIgnoreCase(instancePlan)) continue;
                return instance.getAsJsonObject().getAsJsonObject(CREDENTIALS);
            }
        }
        return null;
    }

    public static String getAPIUrl(String serviceName) {
        return CredentialUtils.getAPIUrl(serviceName, null);
    }

    public static String getAPIUrl(String serviceName, String plan) {
        if (serviceName == null || serviceName.isEmpty()) {
            return null;
        }
        JsonObject services = CredentialUtils.getVCAPServices();
        if (services == null) {
            return null;
        }
        JsonObject credentials = CredentialUtils.getCredentialsObject(services, serviceName, plan);
        if (credentials != null && credentials.has(URL)) {
            return credentials.get(URL).getAsString();
        }
        return null;
    }

    public static void setServices(String services) {
        CredentialUtils.services = services;
    }

    public static class ServiceCredentials {
        private String password;
        private String username;

        private ServiceCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

