/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tradeoff_analytics.v1.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.CategoricalColumn;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.Column;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.DateColumn;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.NumericColumn;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.TextColumn;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColumnTypeAdapter
extends TypeAdapter<Column> {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DESCRIPTION = "description";
    private static final String FORMAT = "format";
    private static final String FULL_NAME = "full_name";
    private static final String GOAL = "goal";
    private static final String HIGH = "high";
    private static final String INSIGNIFICANT_LOSS = "insignificant_loss";
    private static final String IS_OBJECTIVE = "is_objective";
    private static final String KEY = "key";
    private static final Logger LOG = Logger.getLogger(ColumnTypeAdapter.class.getName());
    private static final String LOW = "low";
    private static final String RANGE = "range";
    private static final String PREFERENCE = "preference";
    private static final String SIGNIFICANT_GAIN = "significant_gain";
    private static final String SIGNIFICANT_LOSS = "significant_loss";
    private static final String TYPE2 = "type";
    private final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private void writeCategoricalColumn(CategoricalColumn catCol, JsonWriter writer) throws IOException {
        if (catCol.getPreference() != null) {
            writer.name(PREFERENCE);
            writer.beginArray();
            for (String pref : catCol.getPreference()) {
                writer.value(pref);
            }
            writer.endArray();
        }
        if (catCol.getRange() != null) {
            writer.name(RANGE);
            writer.beginArray();
            for (String value : catCol.getRange()) {
                writer.value(value);
            }
            writer.endArray();
        }
    }

    private void writeDateColumn(DateColumn dateCol, JsonWriter writer) throws IOException {
        if (dateCol.getLow() != null) {
            writer.name(RANGE).beginObject();
            writer.name(LOW).value(this.DATE_FORMATTER.format(dateCol.getLow()));
            writer.name(HIGH).value(this.DATE_FORMATTER.format(dateCol.getHigh()));
            writer.endObject();
        }
    }

    private void writeNumericalColumn(NumericColumn numCol, JsonWriter writer) throws IOException {
        if (numCol.getLow() != null) {
            writer.name(RANGE);
            writer.beginObject();
            writer.name(LOW).value((Number)numCol.getLow());
            writer.name(HIGH).value((Number)numCol.getHigh());
            writer.endObject();
        }
    }

    public Column read(JsonReader reader) throws IOException {
        Column column;
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        Column.ColumnType type = Column.ColumnType.TEXT;
        Column.Goal goal = null;
        Boolean objective = null;
        String key = null;
        String format = null;
        String description = null;
        String fullName = null;
        String low = null;
        String high = null;
        Double significantGain = null;
        Double significantLoss = null;
        Double insignificantLoss = null;
        ArrayList<String> categoricalRange = null;
        ArrayList<String> categoricalPreference = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals(TYPE2)) {
                type = Column.ColumnType.fromString(reader.nextString());
                continue;
            }
            if (name.equals(KEY)) {
                key = reader.nextString();
                continue;
            }
            if (name.equals(GOAL)) {
                goal = Column.Goal.fromString(reader.nextString());
                continue;
            }
            if (name.equals(IS_OBJECTIVE)) {
                objective = reader.nextBoolean();
                continue;
            }
            if (name.equals(FORMAT)) {
                format = reader.nextString();
                continue;
            }
            if (name.equals(DESCRIPTION)) {
                description = reader.nextString();
                continue;
            }
            if (name.equals(FULL_NAME)) {
                fullName = reader.nextString();
                continue;
            }
            if (name.equals(SIGNIFICANT_GAIN)) {
                significantGain = reader.nextDouble();
                continue;
            }
            if (name.equals(SIGNIFICANT_LOSS)) {
                significantLoss = reader.nextDouble();
                continue;
            }
            if (name.equals(INSIGNIFICANT_LOSS)) {
                insignificantLoss = reader.nextDouble();
                continue;
            }
            if (name.equals(PREFERENCE)) {
                reader.beginArray();
                categoricalPreference = new ArrayList<String>();
                while (reader.hasNext()) {
                    categoricalPreference.add(reader.nextString());
                }
                reader.endArray();
                continue;
            }
            if (name.equals(RANGE)) {
                if (reader.peek().equals((Object)JsonToken.BEGIN_ARRAY)) {
                    reader.beginArray();
                    categoricalRange = new ArrayList<String>();
                    while (reader.hasNext()) {
                        categoricalRange.add(reader.nextString());
                    }
                    reader.endArray();
                    continue;
                }
                reader.beginObject();
                while (reader.hasNext()) {
                    name = reader.nextName();
                    if (name.equals(LOW)) {
                        low = reader.nextString();
                        continue;
                    }
                    if (name.equals(HIGH)) {
                        high = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (type == Column.ColumnType.CATEGORICAL) {
            column = new CategoricalColumn();
            if (categoricalRange != null) {
                ((CategoricalColumn)column).setRange(categoricalRange);
            }
            if (categoricalPreference != null) {
                ((CategoricalColumn)column).setRange(categoricalPreference);
            }
        } else if (type == Column.ColumnType.DATETIME) {
            column = new DateColumn();
            if (low != null) {
                try {
                    ((DateColumn)column).withRange(this.DATE_FORMATTER.parse(low), this.DATE_FORMATTER.parse(high));
                }
                catch (ParseException e) {
                    LOG.log(Level.SEVERE, "Error parsing the date", e);
                }
            }
        } else if (type == Column.ColumnType.NUMERIC) {
            column = new NumericColumn();
            if (low != null) {
                ((NumericColumn)column).range(Double.valueOf(low), Double.valueOf(high));
            }
        } else {
            column = new TextColumn();
        }
        column.setKey(key);
        if (description != null) {
            column.setDescription(description);
        }
        if (format != null) {
            column.setFormat(format);
        }
        if (objective != null) {
            column.setObjective(objective);
        }
        if (fullName != null) {
            column.setFullName(fullName);
        }
        if (goal != null) {
            column.setGoal(goal);
        }
        if (key != null) {
            column.setKey(key);
        }
        if (significantGain != null) {
            column.setSignificantGain(significantGain);
        }
        if (significantLoss != null) {
            column.setSignificantLoss(insignificantLoss);
        }
        if (insignificantLoss != null) {
            column.setInsignificantLoss(insignificantLoss);
        }
        return column;
    }

    public void write(JsonWriter writer, Column column) throws IOException {
        writer.beginObject();
        writer.name(KEY).value(column.getKey());
        writer.name(TYPE2).value(column.getType().toString());
        if (column.getGoal() != null) {
            writer.name(GOAL).value(column.getGoal().toString());
        }
        if (column.isObjective() != null) {
            writer.name(IS_OBJECTIVE).value(column.isObjective().booleanValue());
        }
        if (column.getFormat() != null) {
            writer.name(FORMAT).value(column.getFormat());
        }
        if (column.getDescription() != null) {
            writer.name(DESCRIPTION).value(column.getDescription());
        }
        if (column.getFullName() != null) {
            writer.name(FULL_NAME).value(column.getFullName());
        }
        if (column.getSignificantGain() != null) {
            writer.name(SIGNIFICANT_GAIN).value((Number)column.getSignificantGain());
        }
        if (column.getSignificantLoss() != null) {
            writer.name(SIGNIFICANT_LOSS).value((Number)column.getSignificantLoss());
        }
        if (column.getInsignificantLoss() != null) {
            writer.name(INSIGNIFICANT_LOSS).value((Number)column.getInsignificantLoss());
        }
        Column.ColumnType type = column.getType();
        switch (type) {
            case CATEGORICAL: {
                this.writeCategoricalColumn((CategoricalColumn)column, writer);
                break;
            }
            case NUMERIC: {
                this.writeNumericalColumn((NumericColumn)column, writer);
                break;
            }
            case DATETIME: {
                this.writeDateColumn((DateColumn)column, writer);
                break;
            }
        }
        writer.endObject();
        writer.flush();
    }
}

