/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tone_analyzer.v3.model;

import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.Tone;
import java.util.ArrayList;
import java.util.List;

public class ToneOptions {
    private Boolean isHtml;
    private List<Tone> tones;
    private Boolean includeSentences;

    private ToneOptions(Builder builder) {
        this.isHtml = builder.isHtml;
        this.tones = builder.tones;
        this.includeSentences = builder.includeSentences;
    }

    public Boolean html() {
        return this.isHtml;
    }

    public Boolean includeSentences() {
        return this.includeSentences;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<Tone> tones() {
        return this.tones;
    }

    public static class Builder {
        private Boolean isHtml;
        private Boolean includeSentences;
        private List<Tone> tones;

        public Builder() {
        }

        public Builder(ToneOptions options) {
            this.isHtml = options.isHtml;
            this.tones = options.tones;
            this.includeSentences = options.includeSentences;
        }

        public Builder html(Boolean isHtml) {
            this.isHtml = isHtml;
            return this;
        }

        public Builder addTone(Tone tone) {
            if (this.tones == null) {
                this.tones = new ArrayList<Tone>();
            }
            if (!this.tones.contains((Object)tone)) {
                this.tones.add(tone);
            }
            return this;
        }

        public ToneOptions build() {
            return new ToneOptions(this);
        }
    }
}

