/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.text_to_speech.v1;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.AudioFormat;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.CustomTranslation;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.CustomVoiceModel;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Phoneme;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Pronunciation;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Voice;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.ResponseUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TextToSpeech
extends WatsonService {
    private static final String URL = "https://stream.watsonplatform.net/text-to-speech/api";
    private static final String PATH_VOICES = "/v1/voices";
    private static final String PATH_VOICE = "/v1/voices/%s";
    private static final String PATH_SYNTHESIZE = "/v1/synthesize";
    private static final String PATH_GET_PRONUNCIATION = "/v1/pronunciation";
    private static final String PATH_CUSTOMIZATIONS = "/v1/customizations";
    private static final String PATH_CUSTOMIZATION = "/v1/customizations/%s";
    private static final String PATH_WORDS = "/v1/customizations/%s/words";
    private static final String PATH_WORD = "/v1/customizations/%s/words/%s";
    private static final String SERVICE_NAME = "text_to_speech";
    private static final String ACCEPT = "accept";
    private static final String TEXT = "text";
    private static final String VOICE = "voice";
    private static final String VOICES = "voices";
    private static final String FORMAT = "format";
    private static final String CUSTOMIZATION_ID = "customization_id";
    private static final String CUSTOMIZATIONS = "customizations";
    private static final String LANGUAGE = "language";
    private static final String WORDS = "words";
    private static final Type TYPE_GET_VOICES = new TypeToken<List<Voice>>(){}.getType();
    private static final Type TYPE_VOICE_MODELS = new TypeToken<List<CustomVoiceModel>>(){}.getType();
    private static final Type TYPE_CUSTOM_TRANSLATIONS = new TypeToken<List<CustomTranslation>>(){}.getType();
    private static final Gson GSON = GsonSingleton.getGson();

    public TextToSpeech() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public TextToSpeech(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public ServiceCall<List<Voice>> getVoices() {
        Request request = RequestBuilder.get(PATH_VOICES).build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject(TYPE_GET_VOICES, VOICES);
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<Voice> getVoice(String voiceName) {
        Validator.notNull(voiceName, "name can not be null");
        Request request = RequestBuilder.get(String.format(PATH_VOICE, voiceName)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Voice.class));
    }

    public ServiceCall<Pronunciation> getPronunciation(String word, Voice voice, Phoneme phoneme) {
        RequestBuilder requestBuilder = RequestBuilder.get(PATH_GET_PRONUNCIATION).query(TEXT, word);
        if (voice != null) {
            requestBuilder.query(VOICE, voice.getName());
        }
        if (phoneme != null) {
            requestBuilder.query(new Object[]{FORMAT, phoneme});
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(Pronunciation.class));
    }

    public ServiceCall<InputStream> synthesize(String text, Voice voice) {
        return this.synthesize(text, voice, null);
    }

    public ServiceCall<InputStream> synthesize(String text, Voice voice, AudioFormat audioFormat) {
        return this.synthesize(text, voice, audioFormat, null);
    }

    public ServiceCall<InputStream> synthesize(String text, Voice voice, AudioFormat audioFormat, String customizationId) {
        Validator.isTrue(text != null && !text.isEmpty(), "text cannot be null or empty");
        Validator.isTrue(voice != null, "voice cannot be null or empty");
        RequestBuilder request = RequestBuilder.get(PATH_SYNTHESIZE);
        request.query(TEXT, text);
        request.query(VOICE, voice.getName());
        request.query(new Object[]{ACCEPT, audioFormat != null ? audioFormat : AudioFormat.WAV});
        if (customizationId != null) {
            request.query(CUSTOMIZATION_ID, customizationId);
        }
        return this.createServiceCall(request.build(), ResponseConverterUtils.getInputStream());
    }

    public ServiceCall<List<CustomVoiceModel>> getCustomVoiceModels(String language) {
        Validator.notNull(language, "language can not be null");
        Request request = RequestBuilder.get(PATH_CUSTOMIZATIONS).query(LANGUAGE, language).build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject(TYPE_VOICE_MODELS, CUSTOMIZATIONS);
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<CustomVoiceModel> getCustomVoiceModel(String id) {
        Validator.notNull(id, "id can not be null");
        Request request = RequestBuilder.get(String.format(PATH_CUSTOMIZATION, id)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(CustomVoiceModel.class));
    }

    public ServiceCall<CustomVoiceModel> saveCustomVoiceModel(final CustomVoiceModel model) {
        boolean isNew = model.getId() == null;
        String path = isNew ? PATH_CUSTOMIZATIONS : String.format(PATH_CUSTOMIZATION, model.getId());
        RequestBody body = RequestBody.create((MediaType)HttpMediaType.JSON, (String)model.toString());
        Request request = RequestBuilder.post(path).body(body).build();
        return this.createServiceCall(request, new ResponseConverter<CustomVoiceModel>(){

            @Override
            public CustomVoiceModel convert(Response response) {
                CustomVoiceModel newModel = ResponseUtils.getObject(response, CustomVoiceModel.class);
                if (newModel != null && newModel.getId() != null) {
                    model.setId(newModel.getId());
                }
                return model;
            }
        });
    }

    public ServiceCall<Void> deleteCustomVoiceModel(CustomVoiceModel model) {
        Validator.notEmpty(model.getId(), "model id must not be empty");
        Request request = RequestBuilder.delete(String.format(PATH_CUSTOMIZATION, model.getId())).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<List<CustomTranslation>> getWords(CustomVoiceModel model) {
        Validator.notNull(model.getId(), "model id can not be null");
        Request request = RequestBuilder.get(String.format(PATH_WORDS, model.getId())).build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject(TYPE_CUSTOM_TRANSLATIONS, WORDS);
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<Void> saveWords(CustomVoiceModel model, CustomTranslation ... translations) {
        Validator.notEmpty(model.getId(), "model id must not be empty");
        String json = GSON.toJson(Collections.singletonMap(WORDS, translations));
        String path = String.format(PATH_WORDS, model.getId());
        RequestBody body = RequestBody.create((MediaType)HttpMediaType.JSON, (String)json);
        Request request = RequestBuilder.post(path).body(body).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteWord(CustomVoiceModel model, CustomTranslation translation) {
        Validator.notEmpty(model.getId(), "model id must not be empty");
        Validator.notEmpty(translation.getWord(), "word must not be empty");
        String path = String.format(PATH_WORD, model.getId(), RequestUtils.encode(translation.getWord()));
        Request request = RequestBuilder.delete(path).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }
}

