/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util;

import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util.MessageFormatter;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private static final MessageFormatter MSGS = new MessageFormatter(Messages.bundleName());

    private ZipUtils() {
    }

    public static File buildConfigZip(String configName, File parentDir) {
        ZipOutputStream out;
        if (!parentDir.isDirectory()) {
            throw new RuntimeException(MSGS.format(Messages.CONFIG_NOT_DIR_1, parentDir.toString()));
        }
        File zipFile = ZipUtils.createEmptyZipFile(configName);
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(MSGS.format(Messages.ERROR_ZIPPING_1, parentDir.toString()), e);
        }
        try {
            ZipUtils.addFilesToZip(parentDir, out, parentDir);
            File e = zipFile;
            return e;
        }
        catch (IOException e) {
            throw new RuntimeException(MSGS.format(Messages.ERROR_ZIPPING_1, parentDir.toString()), e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static File createEmptyZipFile(String prefix) {
        try {
            return File.createTempFile(prefix, ".zip");
        }
        catch (IOException e) {
            throw new RuntimeException(MSGS.format(Messages.ERROR_CREATING_ZIP_1, prefix + ".zip"), e);
        }
    }

    private static void writeZipEntry(ZipOutputStream out, String name, byte[] data) throws IOException {
        String cleanedName = name == null || name.isEmpty() || !name.startsWith("/") ? name : name.substring(1);
        ZipEntry entry = new ZipEntry(cleanedName);
        out.putNextEntry(entry);
        out.write(data, 0, data.length);
        out.closeEntry();
    }

    private static void addFilesToZip(File currentParentDir, ZipOutputStream out, File globalParentDir) throws IOException {
        for (File child : currentParentDir.listFiles()) {
            if (child.isDirectory()) {
                ZipUtils.addFilesToZip(child, out, globalParentDir);
                continue;
            }
            if (!child.isFile()) continue;
            ZipUtils.writeZipEntry(out, globalParentDir.toURI().relativize(child.toURI()).toString(), ZipUtils.readBytes(child));
        }
    }

    private static byte[] readBytes(File file) {
        FileInputStream in = null;
        byte[] buffer = new byte[(int)file.length()];
        try {
            in = new FileInputStream(file);
            in.read(buffer);
        }
        catch (IOException e) {
            MSGS.format(Messages.ERROR_READING_FILE_1, file.toString(), e);
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buffer;
    }
}

