/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.http;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.NameValue;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RequestBuilder {
    private RequestBody body;
    private HttpUrl httpUrl;
    private final List<NameValue> formParams = new ArrayList<NameValue>();
    private final List<NameValue> headers = new ArrayList<NameValue>();
    private final HTTPMethod method;
    private final List<NameValue> queryParams = new ArrayList<NameValue>();

    public static RequestBuilder delete(String url) {
        return new RequestBuilder(HTTPMethod.DELETE, url);
    }

    public static RequestBuilder get(String url) {
        return new RequestBuilder(HTTPMethod.GET, url);
    }

    public static RequestBuilder post(String url) {
        return new RequestBuilder(HTTPMethod.POST, url);
    }

    public static RequestBuilder put(String url) {
        return new RequestBuilder(HTTPMethod.PUT, url);
    }

    private RequestBuilder(HTTPMethod method, String url) {
        this.method = method;
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this.httpUrl = HttpUrl.parse((String)url);
        if (this.httpUrl == null) {
            this.httpUrl = HttpUrl.parse((String)("http://do.not.use" + url));
        }
    }

    private RequestBuilder add(List<NameValue> params, String name, Object value) {
        if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.addParam(params, name, o);
            }
        } else if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.addParam(params, name, o);
            }
        } else {
            this.addParam(params, name, value);
        }
        return this;
    }

    private void addParam(List<NameValue> params, String name, Object value) {
        params.add(new NameValue(name, value == null ? null : String.valueOf(value)));
    }

    public Request build() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.toUrl());
        if (this.method == HTTPMethod.GET) {
            Validator.isNull(this.body, "cannot send a RequestBody in a GET request");
        } else if (!this.formParams.isEmpty()) {
            FormBody.Builder formBody = new FormBody.Builder();
            for (NameValue param : this.formParams) {
                String value = param.getValue() != null ? param.getValue() : "";
                formBody.add(param.getName(), value);
            }
            this.body = formBody.build();
        } else if (this.body == null) {
            this.body = RequestBody.create(null, (byte[])new byte[0]);
        }
        builder.method(this.method.name(), this.body);
        builder.header("Accept", "application/json");
        for (NameValue header : this.headers) {
            builder.header(header.getName(), header.getValue());
        }
        return builder.build();
    }

    public String toString() {
        return "RequestBuilder [method=" + (Object)((Object)this.method) + ", formParams=" + this.formParams + ", headers=" + this.headers + ", queryParams=" + this.queryParams + ", httpUrl=" + this.httpUrl.toString() + "]";
    }

    private String toUrl() {
        HttpUrl.Builder builder = this.httpUrl.newBuilder();
        for (NameValue param : this.queryParams) {
            builder.addQueryParameter(param.getName(), param.getValue());
        }
        return builder.build().url().toString();
    }

    private RequestBuilder with(List<NameValue> params, Object ... args) {
        if (args != null) {
            Validator.isTrue(args.length % 2 == 0, "need even number of arguments");
            for (int i = 0; i < args.length; i += 2) {
                this.add(params, args[i].toString(), args[i + 1]);
            }
        }
        return this;
    }

    public RequestBuilder body(RequestBody body) {
        this.body = body;
        return this;
    }

    public RequestBuilder bodyContent(String content, String contentType) {
        this.body = RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content);
        return this;
    }

    public RequestBuilder bodyJson(JsonObject json) {
        return this.bodyContent(json.toString(), "application/json");
    }

    public RequestBuilder form(Object ... args) {
        return this.with(this.formParams, args);
    }

    public RequestBuilder header(Object ... args) {
        return this.with(this.headers, args);
    }

    public RequestBuilder query(Object ... args) {
        return this.with(this.queryParams, args);
    }

    private static enum HTTPMethod {
        DELETE,
        GET,
        POST,
        PUT;

    }
}

