/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public final class ConversionUtils {
    private static final Map<String, String> MEDIA_TYPES = new HashMap<String, String>();

    private ConversionUtils() {
    }

    public static String getMediaTypeFromFile(File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        return MEDIA_TYPES.get(fileName.substring(i).toLowerCase());
    }

    public static boolean isValidMediaType(String mediaType) {
        return mediaType != null && MEDIA_TYPES.values().contains(mediaType.toLowerCase());
    }

    public static JsonObject loadCustomConfig(InputStream customConfig) {
        InputStreamReader reader = new InputStreamReader(customConfig);
        return new JsonParser().parse((Reader)reader).getAsJsonObject();
    }

    public static String writeInputStreamToString(InputStream is) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MEDIA_TYPES.put(".htm", "text/html");
        MEDIA_TYPES.put(".html", "text/html");
        MEDIA_TYPES.put(".dot", "application/msword");
        MEDIA_TYPES.put(".doc", "application/msword");
        MEDIA_TYPES.put(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        MEDIA_TYPES.put(".xml", "application/xhtml+xml");
        MEDIA_TYPES.put(".xhtml", "application/xhtml+xml");
        MEDIA_TYPES.put(".pdf", "application/pdf");
    }
}

