/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Answers;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.IndexConfiguration;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.IndexDocumentOptions;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Metadata;
import com.ibm.watson.developer_cloud.document_conversion.v1.util.ConversionTarget;
import com.ibm.watson.developer_cloud.document_conversion.v1.util.ConversionUtils;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class DocumentConversion
extends WatsonService {
    private static final String CONVERSION_TARGET = "conversion_target";
    private static final String DRY_RUN = "dry_run";
    private static final String SERVICE_INSTANCE_ID = "service_instance_id";
    private static final String CLUSTER_ID = "cluster_id";
    private static final String SEARCH_COLLECTION = "search_collection";
    private static final String RETRIEVE_AND_RANK = "retrieve_and_rank";
    private static final String CONVERT_DOCUMENT = "convert_document";
    private static final String CONVERT_DOCUMENT_PATH = "/v1/convert_document";
    private static final String INDEX_DOCUMENT_PATH = "/v1/index_document";
    private static final JsonObject EMPTY_CONFIG = new JsonParser().parse("{}").getAsJsonObject();
    private static final String SERVICE_NAME = "document_conversion";
    private static final String URL = "https://gateway.watsonplatform.net/document-conversion/api";
    public static final String VERSION_DATE_2015_12_01 = "2015-12-01";
    private final String versionDate;

    public DocumentConversion(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        this.versionDate = versionDate;
    }

    public DocumentConversion(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    private Request createConversionRequest(File document, String mediaType, ConversionTarget conversionTarget, JsonObject customConfig) {
        if (document == null || !document.exists()) {
            throw new IllegalArgumentException("document cannot be null and must exist");
        }
        JsonObject config = null;
        config = customConfig != null ? customConfig : EMPTY_CONFIG;
        JsonObject configJson = new JsonObject();
        for (Map.Entry entry : config.entrySet()) {
            configJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        configJson.addProperty(CONVERSION_TARGET, conversionTarget.toString());
        MediaType mType = this.parseMediaType(document, mediaType);
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"config\""}), RequestBody.create((MediaType)HttpMediaType.JSON, (String)configJson.toString())).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\""}), RequestBody.create((MediaType)mType, (File)document)).build();
        return RequestBuilder.post(CONVERT_DOCUMENT_PATH).query("version", this.versionDate).body((RequestBody)body).build();
    }

    public ServiceCall<Answers> convertDocumentToAnswer(File document) {
        Request request = this.createConversionRequest(document, null, ConversionTarget.ANSWER_UNITS, null);
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Answers.class));
    }

    public ServiceCall<Answers> convertDocumentToAnswer(File document, String mediaType) {
        Request request = this.createConversionRequest(document, mediaType, ConversionTarget.ANSWER_UNITS, null);
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Answers.class));
    }

    public ServiceCall<Answers> convertDocumentToAnswer(File document, String mediaType, JsonObject customConfig) {
        Request request = this.createConversionRequest(document, mediaType, ConversionTarget.ANSWER_UNITS, customConfig);
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Answers.class));
    }

    public ServiceCall<String> convertDocumentToHTML(File document) {
        Request request = this.createConversionRequest(document, null, ConversionTarget.NORMALIZED_HTML, null);
        return this.createServiceCall(request, ResponseConverterUtils.getString());
    }

    public ServiceCall<String> convertDocumentToHTML(File document, String mediaType) {
        Request request = this.createConversionRequest(document, mediaType, ConversionTarget.NORMALIZED_HTML, null);
        return this.createServiceCall(request, ResponseConverterUtils.getString());
    }

    public ServiceCall<String> convertDocumentToHTML(File document, String mediaType, JsonObject customConfig) {
        Request request = this.createConversionRequest(document, mediaType, ConversionTarget.NORMALIZED_HTML, customConfig);
        return this.createServiceCall(request, ResponseConverterUtils.getString());
    }

    public ServiceCall<String> convertDocumentToText(File document) {
        Request request = this.createConversionRequest(document, null, ConversionTarget.NORMALIZED_TEXT, null);
        return this.createServiceCall(request, ResponseConverterUtils.getString());
    }

    public ServiceCall<String> convertDocumentToText(File document, String mediaType) {
        Request request = this.createConversionRequest(document, mediaType, ConversionTarget.NORMALIZED_TEXT, null);
        return this.createServiceCall(request, ResponseConverterUtils.getString());
    }

    public ServiceCall<String> convertDocumentToText(File document, String mediaType, JsonObject customConfig) {
        Request request = this.createConversionRequest(document, null, ConversionTarget.NORMALIZED_TEXT, customConfig);
        return this.createServiceCall(request, ResponseConverterUtils.getString());
    }

    public ServiceCall<String> indexDocument(IndexDocumentOptions indexDocumentOptions) {
        if (indexDocumentOptions != null) {
            MediaType mType;
            File document = indexDocumentOptions.document();
            InputStream documentInputStream = indexDocumentOptions.getDocumentInputStream();
            Boolean dryRun = indexDocumentOptions.dryRun();
            String mediaType = indexDocumentOptions.mediaType();
            JsonObject convertDocumentConfig = indexDocumentOptions.convertDocumentConfig();
            IndexConfiguration indexConfiguration = indexDocumentOptions.indexConfiguration();
            Metadata metadata = new Metadata();
            metadata.setMetadata(indexDocumentOptions.metadata());
            if (document == null && documentInputStream == null && metadata.getMetadata() == null) {
                throw new IllegalArgumentException("The request does not contain a document or metadata. At least one of those is required.");
            }
            if (document != null && documentInputStream != null) {
                throw new IllegalArgumentException("Both a document File and InputStream were provided, only one is allowed.");
            }
            if (!dryRun.booleanValue() && indexConfiguration == null) {
                throw new IllegalArgumentException("A configuration is required for indexing.");
            }
            JsonObject config = new JsonObject();
            JsonObject retrieveAndRankConfig = new JsonObject();
            if (dryRun.booleanValue()) {
                retrieveAndRankConfig.addProperty(DRY_RUN, Boolean.valueOf(true));
            } else {
                retrieveAndRankConfig.addProperty(DRY_RUN, Boolean.valueOf(false));
                retrieveAndRankConfig.addProperty(SERVICE_INSTANCE_ID, indexConfiguration.getServiceInstanceId());
                retrieveAndRankConfig.addProperty(CLUSTER_ID, indexConfiguration.getClusterId());
                retrieveAndRankConfig.addProperty(SEARCH_COLLECTION, indexConfiguration.getSearchCollectionName());
            }
            config.add(RETRIEVE_AND_RANK, (JsonElement)retrieveAndRankConfig);
            if (convertDocumentConfig != null) {
                config.add(CONVERT_DOCUMENT, (JsonElement)convertDocumentConfig);
            }
            MultipartBody.Builder multiPartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"config\""}), RequestBody.create((MediaType)HttpMediaType.JSON, (String)config.toString()));
            if (documentInputStream != null) {
                mType = this.parseMediaType(document, mediaType);
                byte[] documentContent = ConversionUtils.writeInputStreamToString(documentInputStream).getBytes();
                multiPartBodyBuilder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\""}), RequestBody.create((MediaType)mType, (byte[])documentContent));
            }
            if (document != null) {
                mType = this.parseMediaType(document, mediaType);
                multiPartBodyBuilder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\""}), RequestBody.create((MediaType)mType, (File)document));
            }
            if (metadata.getMetadata() != null) {
                multiPartBodyBuilder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"metadata\""}), RequestBody.create((MediaType)HttpMediaType.JSON, (String)metadata.toString()));
            }
            MultipartBody body = multiPartBodyBuilder.build();
            Request request = RequestBuilder.post(INDEX_DOCUMENT_PATH).query("version", this.versionDate).body((RequestBody)body).build();
            return this.createServiceCall(request, ResponseConverterUtils.getString());
        }
        throw new IllegalArgumentException("The request does not contain a file or metadata. At least one of those is required.");
    }

    private MediaType parseMediaType(File document, String mediaType) {
        String type;
        String string = type = mediaType != null ? mediaType : ConversionUtils.getMediaTypeFromFile(document);
        if (type == null) {
            throw new RuntimeException("mediaType cannot be null or empty");
        }
        if (!ConversionUtils.isValidMediaType(type)) {
            throw new IllegalArgumentException("file with the given media type is not supported");
        }
        return MediaType.parse((String)type);
    }
}

