/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1_experimental;

import com.ibm.watson.developer_cloud.conversation.v1_experimental.model.MessageRequest;
import com.ibm.watson.developer_cloud.conversation.v1_experimental.model.MessageResponse;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;

public final class ConversationService
extends WatsonService {
    public static final String VERSION_DATE_2016_05_19 = "2016-05-19";
    private static final String URL = "https://gateway.watsonplatform.net/conversation-experimental/api";
    private static final String SERVICE_NAME = "conversation";
    private static final String PATH_MESSAGE = "/v1/workspaces/%s/message";
    private static final String VERSION_PARAM = "version";
    private final String versionDate;

    public ConversationService(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue(versionDate != null && !versionDate.isEmpty(), "'version cannot be null. Use 2016-05-19");
        this.versionDate = versionDate;
    }

    public ConversationService(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public ServiceCall<MessageResponse> message(String workspaceId, MessageRequest request) {
        Validator.isTrue(workspaceId != null && !workspaceId.isEmpty(), "'workspaceId' cannot be null or empty");
        Validator.notNull(request, "'request' cannot be null");
        Validator.isTrue(request.input() != null && !request.input().isEmpty(), "'request.input' cannot be null or empty");
        RequestBuilder builder = RequestBuilder.post(String.format(PATH_MESSAGE, workspaceId));
        builder.query(VERSION_PARAM, this.versionDate);
        builder.bodyJson(GsonSingleton.getGson().toJsonTree((Object)request).getAsJsonObject());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MessageResponse.class));
    }
}

