/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.util;

import com.ibm.watson.developer_cloud.concept_insights.v2.model.Concept;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Corpus;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Document;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Graph;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IDHelper {
    private static final String CONCEPT_ID_REGEX = "^/graphs/[_\\-\\w\\s]*/[_\\-\\w\\s]*/concepts/[_\\-\\w\\s\\(\\)]*$";
    private static final String CORPUS_ID_REGEX = "^/corpora/[_\\-\\w\\s]*/[_\\-\\w\\s]*$";
    private static final String DOCUMENT_ID_REGEX = "^/corpora/[_\\-\\w\\s]*/[_\\-\\w\\s]*/documents/[_\\-\\w\\s]*$";
    private static final String GRAPH_ID_REGEX = "^/graphs/[_\\-\\w\\s]*/[_\\-\\w\\s]*$";

    private IDHelper() {
    }

    private static void validate(String regex, String id, String message) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(id);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static String getConceptId(Concept concept) {
        Validator.notNull(concept, "concept cannot be null");
        Validator.notNull(concept.getId(), "concept.id cannot be null");
        IDHelper.validate(CONCEPT_ID_REGEX, concept.getId(), "Provide a valid concept.id (format is \" (/graphs/{account_id}/{graph}/concepts/{concept})+\")");
        return concept.getId();
    }

    public static String getCorpusId(Corpus corpus, String accountId) {
        Validator.notNull(corpus, "corpus cannot be null");
        if (corpus.getId() != null) {
            IDHelper.validate(CORPUS_ID_REGEX, corpus.getId(), "Provide a valid corpus.id (format is \"/corpora/{account_id}/{corpus} +\")");
            return corpus.getId();
        }
        Validator.notNull(corpus.getName(), "corpus.name cannot be null");
        return "/corpora/" + accountId + "/" + corpus.getName();
    }

    public static String getDocumentId(Document document) {
        Validator.notNull(document, "document cannot be null");
        Validator.notNull(document.getId(), "document.id cannot be null");
        IDHelper.validate(DOCUMENT_ID_REGEX, document.getId(), "Provide a valid document.id (format is \" (/corpora/{account_id}/{corpus}/documents/{document}) +\")");
        return document.getId();
    }

    public static String getGraphId(Graph graph, String accountId) {
        Validator.notNull(graph, "graph object cannot be null");
        if (graph.getId() != null) {
            IDHelper.validate(GRAPH_ID_REGEX, graph.getId(), "Provide a valid graph.id (format is \" (/graphs/{account_id}/{graph}) +\")");
            return graph.getId();
        }
        Validator.notNull(graph.getName(), "graph.name cannot be null");
        return "/graphs/" + accountId + "/" + graph.getName();
    }
}

