/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.AccountPermission;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Corpus
extends GenericModel {
    public static final Corpus IBM_RESEARCHERS = new Corpus("public", "ibmresearcher");
    public static final Corpus TED_TALKS = new Corpus("public", "TEDTalks");
    private Access access;
    @SerializedName(value="users")
    private List<AccountPermission> accountPermissions;
    @SerializedName(value="expires_on")
    private String expiresOn;
    private String id;
    private String name;
    @SerializedName(value="ttl_hours")
    private Integer ttlInHours;

    public Corpus() {
    }

    public Corpus(String accountId, String name) {
        Validator.notEmpty(accountId, "accountId cannot be empty");
        Validator.notEmpty(name, "name cannot be empty");
        this.setName(name);
        this.setId("/corpora/" + accountId + "/" + name);
    }

    public void addAccountPermissions(AccountPermission accountPermission) {
        if (this.accountPermissions == null) {
            this.accountPermissions = new ArrayList<AccountPermission>();
        }
        this.accountPermissions.add(accountPermission);
    }

    public Access getAccess() {
        return this.access;
    }

    public List<AccountPermission> getAccountPermissions() {
        return this.accountPermissions;
    }

    public String getExpiresOn() {
        return this.expiresOn;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getTtlInHours() {
        return this.ttlInHours;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public void setAccountPermissions(List<AccountPermission> accountPermissions) {
        this.accountPermissions = accountPermissions;
    }

    public void setExpiresOn(String expiresOn) {
        this.expiresOn = expiresOn;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTtlInHours(Integer ttlInHours) {
        this.ttlInHours = ttlInHours;
    }

    public static enum Access {
        PRIVATE,
        PUBLIC;

    }
}

