/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Accounts;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Annotations;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Concept;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.ConceptMetadata;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Concepts;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Corpora;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Corpus;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.CorpusProcessingState;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.CorpusStats;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Document;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.DocumentAnnotations;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.DocumentProcessingStatus;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Documents;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Graph;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Graphs;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Matches;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.QueryConcepts;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.RequestedFields;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Scores;
import com.ibm.watson.developer_cloud.concept_insights.v2.util.IDHelper;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Request;

public class ConceptInsights
extends WatsonService {
    private static final String ACCOUNTS_PATH = "/v2/accounts";
    private static final String ANNOTATE_TEXT_PATH = "/annotate_text";
    private static final String ANNOTATIONS_PATH = "/annotations";
    private static final String API_VERSION = "/v2";
    private static final String CONCEPTUAL_SEARCH_PATH = "/conceptual_search";
    private static final String CORPORA_PATH = "/v2/corpora";
    private static final String DOCUMENTS_PATH = "/documents";
    private static final String FORWARD_SLASH = "/";
    private static final String GRAPHS_PATH = "/v2/graphs";
    private static final Gson GSON = GsonSingleton.getGsonWithoutPrettyPrinting();
    private static final String LABEL_SEARCH_PATH = "/label_search";
    private static final String PROCESSING_STATE_PATH = "/processing_state";
    private static final String RELATED_CONCEPTS_PATH = "/related_concepts";
    private static final String RELATION_SCORES_PATH = "/relation_scores";
    private static final String SERVICE_NAME = "concept_insights";
    private static final String STATS_PATH = "/stats";
    private static final String URL = "https://gateway.watsonplatform.net/concept-insights/api";
    public static final String CONCEPT = "concept";
    public static final String CONCEPT_FIELDS = "concept_fields";
    public static final String CONCEPTS = "concepts";
    public static final String CURSOR = "cursor";
    public static final String DOCUMENT_FIELDS = "document_fields";
    public static final String IDS = "ids";
    public static final String LEVEL = "level";
    public static final String LIMIT = "limit";
    public static final String PREFIX = "prefix";
    public static final String QUERY = "query";
    public static final String TEXT = "text";
    private String accountId;

    public ConceptInsights() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public ConceptInsights(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    private <T extends GenericModel> ServiceCall<T> createGETRequest(String resourcePath, Map<String, Object> queryParams, Class<T> returnType) {
        RequestBuilder requestBuilder = RequestBuilder.get(resourcePath);
        if (queryParams != null && !queryParams.isEmpty()) {
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                requestBuilder.query(entry.getKey(), entry.getValue());
            }
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(returnType));
    }

    private String toJson(Object object) {
        return new Gson().toJson(object);
    }

    public ServiceCall<Annotations> annotateText(Graph graph, String text) {
        String graphId = IDHelper.getGraphId(graph, this.getFirstAccountId());
        Validator.notEmpty(text, "text cannot be empty");
        Request request = RequestBuilder.post(API_VERSION + graphId + ANNOTATE_TEXT_PATH).bodyContent(text, "text/plain").header("Accept", "application/json").build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Annotations.class));
    }

    public ServiceCall<QueryConcepts> conceptualSearch(Corpus corpus, Map<String, Object> parameters) {
        RequestedFields fields;
        String[] queryParameters;
        Validator.notNull(parameters.get(IDS), "ids cannot be null");
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        for (String param : queryParameters = new String[]{CURSOR, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParams.put(param, parameters.get(param));
        }
        JsonArray IdsJsonArray = new JsonArray();
        List ids = (List)parameters.get(IDS);
        for (String value : ids) {
            IdsJsonArray.add((JsonElement)new JsonPrimitive(value));
        }
        queryParams.put(IDS, IdsJsonArray.toString());
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && !fields.isEmpty()) {
            queryParams.put(CONCEPT_FIELDS, this.toJson(fields.getFields()));
        }
        if (parameters.get(DOCUMENT_FIELDS) != null && (fields = (RequestedFields)parameters.get(DOCUMENT_FIELDS)) != null && !fields.isEmpty()) {
            queryParams.put(DOCUMENT_FIELDS, this.toJson(fields.getFields()));
        }
        return this.createGETRequest(API_VERSION + corpusId + CONCEPTUAL_SEARCH_PATH, queryParams, QueryConcepts.class);
    }

    public ServiceCall<Void> createCorpus(Corpus corpus) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        Request request = RequestBuilder.put(API_VERSION + corpusId).bodyContent(GSON.toJson((Object)corpus), "application/json").build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> createDocument(Document document) {
        IDHelper.getDocumentId(document);
        Request request = RequestBuilder.put(API_VERSION + document.getId()).bodyContent(GSON.toJson((Object)document), "application/json").build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteCorpus(Corpus corpus) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        Request request = RequestBuilder.delete(API_VERSION + corpusId).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteDocument(Document document) {
        IDHelper.getDocumentId(document);
        Request request = RequestBuilder.delete(API_VERSION + document.getId()).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Accounts> getAccountsInfo() {
        return this.createGETRequest(ACCOUNTS_PATH, null, Accounts.class);
    }

    public ServiceCall<ConceptMetadata> getConcept(Concept concept) {
        IDHelper.getConceptId(concept);
        return this.createGETRequest(API_VERSION + concept.getId(), null, ConceptMetadata.class);
    }

    public ServiceCall<Concepts> getConceptRelatedConcepts(Concept concept, Map<String, Object> parameters) {
        RequestedFields fields;
        String[] queryParms;
        String conceptId = IDHelper.getConceptId(concept);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : queryParms = new String[]{LEVEL, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && !fields.isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, this.toJson(fields.getFields()));
        }
        return this.createGETRequest(API_VERSION + conceptId + RELATED_CONCEPTS_PATH, queryParameters, Concepts.class);
    }

    public ServiceCall<Corpus> getCorpus(Corpus corpus) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        return this.createGETRequest(API_VERSION + corpusId, null, Corpus.class);
    }

    public ServiceCall<CorpusProcessingState> getCorpusProcessingState(Corpus corpus) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        return this.createGETRequest(API_VERSION + corpusId + PROCESSING_STATE_PATH, null, CorpusProcessingState.class);
    }

    public ServiceCall<Concepts> getCorpusRelatedConcepts(Corpus corpus, Map<String, Object> parameters) {
        RequestedFields fields;
        String[] params;
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : params = new String[]{LEVEL, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && !fields.isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, this.toJson(fields.getFields()));
        }
        return this.createGETRequest(API_VERSION + corpusId + RELATED_CONCEPTS_PATH, queryParameters, Concepts.class);
    }

    public ServiceCall<Scores> getCorpusRelationScores(Corpus corpus, List<Concept> concepts) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        Validator.notEmpty(concepts, "concepts cannot be empty");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        JsonObject contentJson = new JsonObject();
        JsonArray conceptsJson = new JsonArray();
        for (Concept con : concepts) {
            conceptsJson.add((JsonElement)new JsonPrimitive(con.getId()));
        }
        contentJson.add(CONCEPTS, (JsonElement)conceptsJson);
        queryParameters.put(CONCEPTS, conceptsJson.toString());
        return this.createGETRequest(API_VERSION + corpusId + RELATION_SCORES_PATH, queryParameters, Scores.class);
    }

    public ServiceCall<CorpusStats> getCorpusStats(Corpus corpus) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        return this.createGETRequest(API_VERSION + corpusId + STATS_PATH, null, CorpusStats.class);
    }

    public ServiceCall<Document> getDocument(Document document) {
        String documentId = IDHelper.getDocumentId(document);
        return this.createGETRequest(API_VERSION + documentId, null, Document.class);
    }

    public ServiceCall<DocumentAnnotations> getDocumentAnnotations(Document document) {
        String documentId = IDHelper.getDocumentId(document);
        return this.createGETRequest(API_VERSION + documentId + ANNOTATIONS_PATH, null, DocumentAnnotations.class);
    }

    public ServiceCall<DocumentProcessingStatus> getDocumentProcessingState(Document document) {
        String documentId = IDHelper.getDocumentId(document);
        return this.createGETRequest(API_VERSION + documentId + PROCESSING_STATE_PATH, null, DocumentProcessingStatus.class);
    }

    public ServiceCall<Concepts> getDocumentRelatedConcepts(Document document, Map<String, Object> parameters) {
        RequestedFields fields;
        String documentId = IDHelper.getDocumentId(document);
        String[] queryParameters = new String[]{LEVEL, LIMIT};
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        for (String param : queryParameters) {
            if (!parameters.containsKey(param)) continue;
            queryParams.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && !fields.isEmpty()) {
            queryParams.put(CONCEPT_FIELDS, this.toJson(fields.getFields()));
        }
        return this.createGETRequest(API_VERSION + documentId + RELATED_CONCEPTS_PATH, queryParams, Concepts.class);
    }

    public ServiceCall<Scores> getDocumentRelationScores(Document document, List<Concept> concepts) {
        String documentId = IDHelper.getDocumentId(document);
        Validator.notEmpty(concepts, "concepts cannot be empty");
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        JsonObject contentJson = new JsonObject();
        JsonArray conceptsJson = new JsonArray();
        for (Concept con : concepts) {
            conceptsJson.add((JsonElement)new JsonPrimitive(con.getId()));
        }
        contentJson.add(CONCEPTS, (JsonElement)conceptsJson);
        queryParams.put(CONCEPTS, conceptsJson.toString());
        return this.createGETRequest(API_VERSION + documentId + RELATION_SCORES_PATH, queryParams, Scores.class);
    }

    public String getFirstAccountId() {
        Accounts accounts;
        if (this.accountId == null && (accounts = this.getAccountsInfo().execute()) != null && accounts.getAccounts() != null && !accounts.getAccounts().isEmpty()) {
            this.accountId = accounts.getAccounts().get(0).getId();
        }
        return this.accountId;
    }

    public ServiceCall<Concepts> getGraphRelatedConcepts(Graph graph, List<Concept> concepts, Map<String, Object> parameters) {
        RequestedFields fields;
        String[] queryParms;
        String graphId = IDHelper.getGraphId(graph, this.getFirstAccountId());
        Validator.notEmpty(concepts, "concepts cannot be empty");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : queryParms = new String[]{LEVEL, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && !fields.isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, this.toJson(fields.getFields()));
        }
        JsonObject contentJson = new JsonObject();
        JsonArray conceptsJson = new JsonArray();
        for (Concept concept : concepts) {
            conceptsJson.add((JsonElement)new JsonPrimitive(concept.getId()));
        }
        contentJson.add(CONCEPTS, (JsonElement)conceptsJson);
        queryParameters.put(CONCEPTS, conceptsJson.toString());
        return this.createGETRequest(API_VERSION + graphId + RELATED_CONCEPTS_PATH, queryParameters, Concepts.class);
    }

    public ServiceCall<Scores> getGraphRelationScores(Concept concept, List<String> concepts) {
        String conceptId = IDHelper.getConceptId(concept);
        Validator.notEmpty(concepts, "concepts cannot be empty");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        JsonObject contentJson = new JsonObject();
        JsonArray conceptsJson = new JsonArray();
        for (String value : concepts) {
            conceptsJson.add((JsonElement)new JsonPrimitive(value));
        }
        contentJson.add(CONCEPTS, (JsonElement)conceptsJson);
        queryParameters.put(CONCEPTS, conceptsJson.toString());
        return this.createGETRequest(API_VERSION + conceptId + RELATION_SCORES_PATH, queryParameters, Scores.class);
    }

    public ServiceCall<Corpora> listCorpora() {
        return this.createGETRequest(CORPORA_PATH, null, Corpora.class);
    }

    public ServiceCall<Corpora> listCorpora(String accountId) {
        Validator.notEmpty(accountId, "account_id cannot be empty");
        return this.createGETRequest("/v2/corpora/" + accountId, null, Corpora.class);
    }

    public ServiceCall<Documents> listDocuments(Corpus corpus) {
        return this.listDocuments(corpus, null);
    }

    public ServiceCall<Documents> listDocuments(Corpus corpus, Map<String, Object> parameters) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String[] queryParams = new String[]{CURSOR, LIMIT};
        if (parameters != null && !parameters.isEmpty()) {
            for (String param : queryParams) {
                if (!parameters.containsKey(param)) continue;
                queryParameters.put(param, parameters.get(param));
            }
            if (parameters.get(QUERY) != null) {
                queryParameters.put(QUERY, parameters.get(QUERY));
            }
        }
        return this.createGETRequest(API_VERSION + corpusId + DOCUMENTS_PATH, queryParameters, Documents.class);
    }

    public ServiceCall<Graphs> listGraphs() {
        return this.createGETRequest(GRAPHS_PATH, null, Graphs.class);
    }

    public ServiceCall<Matches> searchCorpusByLabel(Corpus corpus, Map<String, Object> parameters) {
        RequestedFields fields;
        String[] queryParams;
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        Validator.notEmpty((String)parameters.get(QUERY), "query cannot be empty");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : queryParams = new String[]{QUERY, PREFIX, LIMIT, CONCEPTS}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && !fields.isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, this.toJson(fields.getFields()));
        }
        if (parameters.get(DOCUMENT_FIELDS) != null && (fields = (RequestedFields)parameters.get(DOCUMENT_FIELDS)) != null && !fields.isEmpty()) {
            queryParameters.put(DOCUMENT_FIELDS, this.toJson(fields.getFields()));
        }
        return this.createGETRequest(API_VERSION + corpusId + LABEL_SEARCH_PATH, queryParameters, Matches.class);
    }

    public ServiceCall<Matches> searchGraphsConceptByLabel(Graph graph, Map<String, Object> parameters) {
        RequestedFields fields;
        String[] params;
        String graphId = IDHelper.getGraphId(graph, this.getFirstAccountId());
        Validator.notEmpty((String)parameters.get(QUERY), "query cannot be empty");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : params = new String[]{QUERY, PREFIX, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && !fields.isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, this.toJson(fields.getFields()));
        }
        return this.createGETRequest(API_VERSION + graphId + LABEL_SEARCH_PATH, queryParameters, Matches.class);
    }

    public ServiceCall<Void> updateCorpus(Corpus corpus) {
        String corpusId = IDHelper.getCorpusId(corpus, this.getFirstAccountId());
        Request request = RequestBuilder.post(API_VERSION + corpusId).bodyContent(GSON.toJson((Object)corpus), "application/json").build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> updateDocument(Document document) {
        String documentId = IDHelper.getDocumentId(document);
        Request request = RequestBuilder.post(API_VERSION + documentId).bodyContent(GSON.toJson((Object)document), "application/json").build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }
}

