/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.AlchemyGenericModel;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageFaces;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageKeywords;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageLink;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageSceneText;
import com.ibm.watson.developer_cloud.alchemy.v1.util.AlchemyEndPoints;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class AlchemyVision
extends AlchemyService {
    private static final String FORCE_SHOW_ALL = "forceShowAll";
    private static final String HTML = "html";
    private static final String IMAGE = "image";
    private static final String IMAGE_POST_MODE = "imagePostMode";
    private static final String KNOWLEDGE_GRAPH = "knowledgeGraph";
    private static final String NOT_RAW = "not-raw";
    private static final String RAW = "raw";
    private static final String URL = "url";

    public AlchemyVision() {
    }

    public AlchemyVision(String apiKey) {
        super(apiKey);
    }

    private <T extends AlchemyGenericModel> ServiceCall<T> createServiceCall(Map<String, Object> params, AlchemyEndPoints.AlchemyAPI operation, Class<T> returnType) {
        String inputType = this.getInputFormat(params, IMAGE, URL, HTML);
        String path = AlchemyEndPoints.getPath(operation, inputType);
        RequestBuilder requestBuilder = RequestBuilder.post(path);
        if (IMAGE.equals(inputType)) {
            if (params.get(IMAGE) instanceof String) {
                params.put(IMAGE_POST_MODE, NOT_RAW);
            } else {
                params.put(IMAGE_POST_MODE, RAW);
                File image = (File)params.get(IMAGE);
                if (!image.exists()) {
                    throw new IllegalArgumentException("The file: " + image.getAbsolutePath() + " does not exist.");
                }
                requestBuilder.body(RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)((File)params.get(IMAGE))));
                params.remove(IMAGE);
            }
        }
        params.put("outputMode", "json");
        for (String param : params.keySet()) {
            if (inputType.equals(IMAGE)) {
                requestBuilder.query(param, params.get(param));
                continue;
            }
            requestBuilder.form(param, params.get(param));
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(returnType));
    }

    public ServiceCall<ImageSceneText> getImageSceneText(File image) {
        Validator.notNull(image, "image cannot be null");
        Validator.isTrue(image.exists(), "image file: " + image.getAbsolutePath() + " not found");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IMAGE, image);
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_SCENE_TEXT, ImageSceneText.class);
    }

    public ServiceCall<ImageSceneText> getImageSceneText(URL url) {
        Validator.notNull(url, "url cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(URL, url);
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_SCENE_TEXT, ImageSceneText.class);
    }

    public ServiceCall<ImageKeywords> getImageKeywords(File image, Boolean forceShowAll, Boolean knowledgeGraph) {
        Validator.notNull(image, "image cannot be null");
        Validator.isTrue(image.exists(), "image file: " + image.getAbsolutePath() + " not found");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IMAGE, image);
        if (forceShowAll != null) {
            params.put(FORCE_SHOW_ALL, forceShowAll != false ? 1 : 0);
        }
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_KEYWORDS, ImageKeywords.class);
    }

    public ServiceCall<ImageKeywords> getImageKeywords(URL url, Boolean forceShowAll, Boolean knowledgeGraph) {
        Validator.notNull(url, "url cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(URL, url);
        if (forceShowAll != null) {
            params.put(FORCE_SHOW_ALL, forceShowAll != false ? 1 : 0);
        }
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_KEYWORDS, ImageKeywords.class);
    }

    public ServiceCall<ImageLink> getImageLink(URL url) {
        Validator.notNull(url, "url cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(URL, url);
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_LINK, ImageLink.class);
    }

    public ServiceCall<ImageLink> getImageLink(String html) {
        Validator.notNull(html, "html cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(HTML, html);
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_LINK, ImageLink.class);
    }

    public ServiceCall<ImageFaces> recognizeFaces(File image, Boolean knowledgeGraph) {
        Validator.notNull(image, "image cannot be null");
        Validator.isTrue(image.exists(), "image file: " + image.getAbsolutePath() + " not found");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IMAGE, image);
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_RECOGNITION, ImageFaces.class);
    }

    public ServiceCall<ImageFaces> recognizeFaces(URL url, Boolean knowledgeGraph) {
        Validator.notNull(url, "url cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(URL, url);
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.IMAGE_RECOGNITION, ImageFaces.class);
    }
}

