/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import okhttp3.HttpUrl;

public class VisualRecognitionOptions {
    private File imagesFile;
    private HttpUrl url;

    private VisualRecognitionOptions(Builder builder) {
        this.imagesFile = builder.imagesFile;
        this.url = builder.url;
    }

    public File images() {
        return this.imagesFile;
    }

    public HttpUrl url() {
        return this.url;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private File imagesFile;
        private HttpUrl url;

        private Builder(VisualRecognitionOptions options) {
            this();
            this.imagesFile = options.imagesFile;
            this.url = options.url;
        }

        public Builder images(File imagesFile) {
            Validator.notNull(imagesFile, "'imagesFile' cannot be null");
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder url(HttpUrl url) {
            Validator.notNull(url, "'url' cannot be null");
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            return this.url(HttpUrl.parse(url));
        }

        public Builder() {
        }

        public VisualRecognitionOptions build() {
            Validator.isTrue(this.url != null || this.imagesFile != null, "url or imagesFile should be specified");
            return new VisualRecognitionOptions(this);
        }
    }
}

