/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CreateClassifierOptions {
    private File negativeExamples;
    private Map<String, File> positiveExamplesByName;
    private String classifierName;

    private CreateClassifierOptions(Builder builder) {
        String errorMessage = "To create a classifier, you must supply at least 2 zip files - either 2 positive example sets, or 1 positive and 1 negative set";
        Validator.notNull(builder.classifierName, "'classifierName' cannot be null");
        Validator.isTrue(!builder.positiveExamplesByName.isEmpty(), "There are no classes. " + errorMessage);
        boolean hasExamples = builder.positiveExamplesByName.size() > 1 || builder.negativeExamples != null && builder.positiveExamplesByName.size() == 1;
        Validator.isTrue(hasExamples, errorMessage);
        this.classifierName = builder.classifierName;
        this.negativeExamples = builder.negativeExamples;
        this.positiveExamplesByName = builder.positiveExamplesByName;
    }

    public Set<String> classNames() {
        return this.positiveExamplesByName.keySet();
    }

    public File positiveExamplesByClassName(String className) {
        return this.positiveExamplesByName.get(className);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String classifierName() {
        return this.classifierName;
    }

    public File negativeExamples() {
        return this.negativeExamples;
    }

    public static class Builder {
        private File negativeExamples;
        private Map<String, File> positiveExamplesByName = new HashMap<String, File>();
        private String classifierName;

        private Builder(CreateClassifierOptions options) {
            this();
            this.classifierName = options.classifierName;
            this.negativeExamples = options.negativeExamples;
            this.positiveExamplesByName.putAll(options.positiveExamplesByName);
        }

        public Builder() {
        }

        public Builder addClass(String className, File positiveExamples) {
            Validator.notNull(className, "'className' cannot be null");
            Validator.notNull(positiveExamples, "'positiveExamples' cannot be null");
            this.positiveExamplesByName.put(className, positiveExamples);
            return this;
        }

        public Builder negativeExamples(File negativeExamples) {
            this.negativeExamples = negativeExamples;
            return this;
        }

        public CreateClassifierOptions build() {
            return new CreateClassifierOptions(this);
        }

        public Builder classifierName(String classifierName) {
            Validator.notNull(classifierName, "'classifierName' cannot be null");
            this.classifierName = classifierName;
            return this;
        }
    }
}

