/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import okhttp3.Response;

public final class ResponseConverterUtils {
    private ResponseConverterUtils() {
    }

    public static <T> ResponseConverter<T> getGenericObject(final Type type, final String property) {
        return new ResponseConverter<T>(){

            @Override
            public T convert(Response response) {
                JsonObject json = ResponseUtils.getJsonObject(response);
                return GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(json.get(property), type);
            }
        };
    }

    public static ResponseConverter<InputStream> getInputStream() {
        return new ResponseConverter<InputStream>(){

            @Override
            public InputStream convert(Response response) {
                return ResponseUtils.getInputStream(response);
            }
        };
    }

    public static <T extends GenericModel> ResponseConverter<T> getObject(final Class<? extends T> type) {
        return new ResponseConverter<T>(){

            @Override
            public T convert(Response response) {
                return ResponseUtils.getObject(response, type);
            }
        };
    }

    public static ResponseConverter<String> getString() {
        return new ResponseConverter<String>(){

            @Override
            public String convert(Response response) {
                return ResponseUtils.getString(response);
            }
        };
    }

    public static ResponseConverter<Void> getVoid() {
        return new ResponseConverter<Void>(){

            @Override
            public Void convert(Response response) {
                ResponseUtils.getString(response);
                return null;
            }
        };
    }
}

