/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateDeserializer
implements JsonDeserializer<Date> {
    private static final String DATE_FROM_ALCHEMY = "yyyyMMdd'T'HHmmss";
    private static final String DATE_FROM_DIALOG = "yyyy-MM-dd HH:mm:ss";
    protected static final String DATE_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DATE_WITHOUT_SECONDS = "yyyy-MM-dd'T'HH:mm:ssZ";
    private final SimpleDateFormat alchemyDateFormatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private final SimpleDateFormat dialogDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat utcDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final SimpleDateFormat utcWithoutSecondsDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final List<SimpleDateFormat> FORMATS = Arrays.asList(this.utcDateFormatter, this.utcWithoutSecondsDateFormatter, this.dialogDateFormatter, this.alchemyDateFormatter);
    private static final Logger LOG = Logger.getLogger(DateDeserializer.class.getName());

    @Override
    public synchronized Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull() || json.getAsString().isEmpty()) {
            return null;
        }
        String dateAsString = json.getAsJsonPrimitive().getAsString().replaceAll("Z$", "+0000");
        ParseException e = null;
        for (SimpleDateFormat format : this.FORMATS) {
            try {
                return format.parse(dateAsString);
            }
            catch (ParseException e1) {
                e = e1;
            }
        }
        LOG.log(Level.SEVERE, "Error parsing: " + dateAsString, e);
        return null;
    }
}

