/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tradeoff_analytics.v1;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Dilemma;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Problem;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;

public class TradeoffAnalytics
extends WatsonService {
    private static final String GENERATE_VISUALIZATION = "generate_visualization";
    private static final String PATH_DILEMMAS = "/v1/dilemmas";
    private static final String SERVICE_NAME = "tradeoff_analytics";
    private static final String URL = "https://gateway.watsonplatform.net/tradeoff-analytics/api";

    public TradeoffAnalytics() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public TradeoffAnalytics(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public ServiceCall<Dilemma> dilemmas(Problem problem) {
        return this.dilemmas(problem, null);
    }

    public ServiceCall<Dilemma> dilemmas(Problem problem, Boolean generateVisualization) {
        Validator.notNull(problem, "problem was not specified");
        String contentJson = GsonSingleton.getGsonWithoutPrettyPrinting().toJson(problem);
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_DILEMMAS).bodyContent(contentJson, "application/json");
        if (generateVisualization != null) {
            requestBuilder.query(GENERATE_VISUALIZATION, generateVisualization);
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(Dilemma.class));
    }
}

