/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tone_analyzer.v3;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.ToneAnalysis;
import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.ToneOptions;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;

public class ToneAnalyzer
extends WatsonService {
    private static final String PATH_TONE = "/v3/tone";
    private static final String SERVICE_NAME = "tone_analyzer";
    private static final String TEXT = "text";
    private static final String URL = "https://gateway.watsonplatform.net/tone-analyzer/api";
    private static final String VERSION_DATE = "version";
    private static final String TONES = "tones";
    private static final String SENTENCES = "sentences";
    private String versionDate;
    public static final String VERSION_DATE_2016_05_19 = "2016-05-19";

    public ToneAnalyzer(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        this.versionDate = versionDate;
    }

    public ToneAnalyzer(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public ServiceCall<ToneAnalysis> getTone(String text, ToneOptions options) {
        Validator.notNull(text, "text cannot be null");
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_TONE).query(VERSION_DATE, this.versionDate);
        if (options != null && options.html() != null && options.html().booleanValue()) {
            requestBuilder.header("Content-Type", "text/html");
            requestBuilder.bodyContent(text, "text/html");
        } else {
            JsonObject contentJson = new JsonObject();
            contentJson.addProperty(TEXT, text);
            requestBuilder.bodyJson(contentJson);
        }
        if (options != null && options.tones() != null) {
            requestBuilder.query(TONES, RequestUtils.join(options.tones(), ","));
        }
        if (options != null && options.includeSentences() != null) {
            requestBuilder.query(SENTENCES, options.includeSentences().toString());
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(ToneAnalysis.class));
    }
}

