/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.websocket;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RecognizeOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.RecognizeCallback;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;

public class WebSocketManager {
    private final String url;
    private final OkHttpClient client;
    private String token;
    private static final Gson GSON = GsonSingleton.getGsonWithoutPrettyPrinting();
    private static final Logger LOG = Logger.getLogger(WebSocketManager.class.getName());

    public WebSocketManager(String url, OkHttpClient client, String token) {
        this.url = url;
        this.client = client;
        this.token = token;
    }

    private WebSocketCall createConnection(RecognizeOptions options) {
        String speechModel = options.model() == null ? "" : "?model=" + options.model();
        Request connectionRequest = new Request.Builder().url(this.url + speechModel).addHeader("X-Watson-Authorization-Token", this.token).build();
        return WebSocketCall.create(this.client, connectionRequest);
    }

    public void recognize(InputStream stream, RecognizeOptions options, RecognizeCallback delegate) {
        this.createConnection(options).enqueue(new SpeechToTextWebSocketListener(stream, options, delegate));
    }

    private class SpeechToTextWebSocketListener
    implements WebSocketListener {
        private static final String STATE = "state";
        private static final String MODEL = "model";
        private static final String START = "start";
        private static final String STOP = "stop";
        private static final String ACTION = "action";
        private static final int FOUR_KB = 4096;
        private static final String ERROR = "error";
        private static final String RESULTS = "results";
        private static final String TIMEOUT_PREFIX = "No speech detected for";
        private final InputStream stream;
        private final RecognizeOptions options;
        private final RecognizeCallback callback;
        private WebSocket socket;
        private boolean socketOpen = true;
        private Thread audioThread = null;
        private int CLOSE_NORMAL = 1000;

        public SpeechToTextWebSocketListener(InputStream stream, RecognizeOptions options, RecognizeCallback callback) {
            this.stream = stream;
            this.options = options;
            this.callback = callback;
        }

        @Override
        public void onClose(int code, String reason) {
            this.socketOpen = false;
            this.callback.onDisconnected();
        }

        @Override
        public void onFailure(IOException e, Response response) {
            this.socketOpen = false;
            this.callback.onError(e);
        }

        @Override
        public void onMessage(ResponseBody response) throws IOException {
            String message = response.string();
            JsonObject json = new JsonParser().parse(message).getAsJsonObject();
            if (json.has(ERROR)) {
                String error = json.get(ERROR).getAsString();
                if (!error.startsWith(TIMEOUT_PREFIX)) {
                    this.callback.onError(new RuntimeException(error));
                }
            } else if (json.has(RESULTS)) {
                this.callback.onTranscription(GSON.fromJson(message, SpeechResults.class));
            } else if (json.has(STATE)) {
                if (this.audioThread == null) {
                    this.audioThread = new Thread(){

                        @Override
                        public void run() {
                            SpeechToTextWebSocketListener.this.sendInputSteam(SpeechToTextWebSocketListener.this.stream);
                            if (SpeechToTextWebSocketListener.this.socketOpen) {
                                try {
                                    SpeechToTextWebSocketListener.this.socket.sendMessage(RequestBody.create(WebSocket.TEXT, SpeechToTextWebSocketListener.this.buildStopMessage()));
                                }
                                catch (IOException e) {
                                    LOG.log(Level.SEVERE, e.getMessage(), e);
                                }
                            }
                        }
                    };
                    this.audioThread.start();
                } else {
                    this.socket.close(this.CLOSE_NORMAL, "Transcription completed");
                }
            }
        }

        @Override
        public void onOpen(WebSocket socket, Response response) {
            this.callback.onConnected();
            this.socket = socket;
            try {
                socket.sendMessage(RequestBody.create(WebSocket.TEXT, this.buildStartMessage(this.options)));
            }
            catch (IOException e) {
                this.callback.onError(e);
            }
        }

        @Override
        public void onPong(Buffer buffer) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendInputSteam(InputStream inputStream) {
            byte[] buffer = new byte[4096];
            try {
                int read;
                while ((read = inputStream.read(buffer)) > 0 && this.socketOpen) {
                    if (read == 4096) {
                        this.socket.sendMessage(RequestBody.create(WebSocket.BINARY, buffer));
                        continue;
                    }
                    this.socket.sendMessage(RequestBody.create(WebSocket.BINARY, Arrays.copyOfRange(buffer, 0, read)));
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }

        private String buildStartMessage(RecognizeOptions options) {
            JsonObject startMessage = new JsonParser().parse(new Gson().toJson(options)).getAsJsonObject();
            startMessage.remove(MODEL);
            startMessage.addProperty(ACTION, START);
            return startMessage.toString();
        }

        private String buildStopMessage() {
            JsonObject stopMessage = new JsonObject();
            stopMessage.addProperty(ACTION, STOP);
            return stopMessage.toString();
        }
    }
}

