/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechSession;
import com.ibm.watson.developer_cloud.util.Validator;
import okhttp3.MediaType;

public class RecognizeOptions {
    @SerializedName(value="content-type")
    private String contentType;
    private Boolean continuous;
    private Integer inactivityTimeout;
    @SerializedName(value="interim_results")
    private Boolean interimResults;
    private String[] keywords;
    @SerializedName(value="keywords_threshold")
    private Double keywordsThreshold;
    private Integer maxAlternatives;
    private Boolean profanityFilter;
    private String model;
    private String sessionId;
    private Boolean timestamps;
    @SerializedName(value="word_alternatives_threshold")
    private Double wordAlternativesThreshold;
    @SerializedName(value="word_confidence")
    private Boolean wordConfidence;

    private RecognizeOptions(Builder builder) {
        this.contentType = builder.contentType;
        this.continuous = builder.continuous;
        this.inactivityTimeout = builder.inactivityTimeout;
        this.interimResults = builder.interimResults;
        this.keywords = builder.keywords;
        this.keywordsThreshold = builder.keywordsThreshold;
        this.maxAlternatives = builder.maxAlternatives;
        this.model = builder.model;
        this.sessionId = builder.sessionId;
        this.timestamps = builder.timestamps;
        this.wordAlternativesThreshold = builder.wordAlternativesThreshold;
        this.wordConfidence = builder.wordConfidence;
        this.profanityFilter = builder.profanityFilter;
    }

    public String contentType() {
        return this.contentType;
    }

    public Boolean profanityFilter() {
        return this.profanityFilter;
    }

    public Boolean continuous() {
        return this.continuous;
    }

    public Integer inactivityTimeout() {
        return this.inactivityTimeout;
    }

    public Boolean interimResults() {
        return this.interimResults;
    }

    public String[] keywords() {
        return this.keywords == null ? null : (String[])this.keywords.clone();
    }

    public Double keywordsThreshold() {
        return this.keywordsThreshold;
    }

    public Integer maxAlternatives() {
        return this.maxAlternatives;
    }

    public String model() {
        return this.model;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String sessionId() {
        return this.sessionId;
    }

    public Boolean timestamps() {
        return this.timestamps;
    }

    public Double wordAlternativesThreshold() {
        return this.wordAlternativesThreshold;
    }

    public Boolean wordConfidence() {
        return this.wordConfidence;
    }

    public static class Builder {
        private String contentType;
        private Boolean continuous;
        private Integer inactivityTimeout;
        private Boolean interimResults;
        private String[] keywords;
        private Double keywordsThreshold;
        private Integer maxAlternatives;
        private String model;
        private String sessionId;
        private Boolean timestamps;
        private Double wordAlternativesThreshold;
        private Boolean wordConfidence;
        private Boolean profanityFilter;

        private Builder(RecognizeOptions options) {
            this.contentType = options.contentType;
            this.continuous = options.continuous;
            this.inactivityTimeout = options.inactivityTimeout;
            this.interimResults = options.interimResults;
            this.keywords = options.keywords;
            this.keywordsThreshold = options.keywordsThreshold;
            this.maxAlternatives = options.maxAlternatives;
            this.model = options.model;
            this.sessionId = options.sessionId;
            this.timestamps = options.timestamps;
            this.wordAlternativesThreshold = options.wordAlternativesThreshold;
            this.wordConfidence = options.wordConfidence;
            this.profanityFilter = options.profanityFilter;
        }

        public Builder() {
        }

        public RecognizeOptions build() {
            return new RecognizeOptions(this);
        }

        public Builder contentType(String contentType) {
            Validator.isTrue(MediaType.parse(contentType) != null && contentType.startsWith("audio/"), "contentType is not a valid mime audio format. Valid formats start with 'audio/'");
            Validator.isTrue(!contentType.contains("audio/l16") || contentType.contains("rate"), "When using PCM the audio rate should be specified.");
            this.contentType = contentType;
            return this;
        }

        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        public Builder continuous(Boolean continuous) {
            this.continuous = continuous;
            return this;
        }

        public Builder inactivityTimeout(Integer inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
            return this;
        }

        public Builder interimResults(Boolean interimResults) {
            this.interimResults = interimResults;
            return this;
        }

        public Builder keywords(String ... keywords) {
            this.keywords = keywords == null ? null : (String[])keywords.clone();
            return this;
        }

        public Builder keywordsThreshold(Double keywordsThreshold) {
            this.keywordsThreshold = keywordsThreshold;
            return this;
        }

        public Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder session(SpeechSession session) {
            this.sessionId = session.getSessionId();
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public Builder wordAlternativesThreshold(Double wordAlternativesThreshold) {
            this.wordAlternativesThreshold = wordAlternativesThreshold;
            return this;
        }

        public Builder wordConfidence(Boolean wordConfidence) {
            this.wordConfidence = wordConfidence;
            return this;
        }
    }
}

