/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1;

import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.http.ServiceCallback;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RecognizeOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechSession;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechSessionStatus;
import com.ibm.watson.developer_cloud.speech_to_text.v1.util.MediaTypeUtils;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.RecognizeCallback;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.WebSocketManager;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class SpeechToText
extends WatsonService {
    private static final String CONTINUOUS = "continuous";
    private static final String INACTIVITY_TIMEOUT = "inactivity_timeout";
    private static final String KEYWORDS = "keywords";
    private static final String KEYWORDS_THRESHOLD = "keywords_threshold";
    private static final String MAX_ALTERNATIVES = "max_alternatives";
    private static final String MODEL = "model";
    private static final String PATH_MODEL = "/v1/models/%s";
    private static final String PATH_MODELS = "/v1/models";
    private static final String PATH_RECOGNIZE = "/v1/recognize";
    private static final String PATH_SESSION = "/v1/sessions/%s";
    private static final String PATH_SESSION_RECOGNIZE = "/v1/sessions/%s/recognize";
    private static final String PATH_SESSIONS = "/v1/sessions";
    private static final String SERVICE_NAME = "speech_to_text";
    private static final String TIMESTAMPS = "timestamps";
    private static final String URL = "https://stream.watsonplatform.net/speech-to-text/api";
    private static final String WORD_ALTERNATIVES_THRESHOLD = "word_alternatives_threshold";
    private static final String WORD_CONFIDENCE = "word_confidence";
    private static final String PROFANITY_FILTER = "profanity_filter";
    private static final Type TYPE_LIST_MODELS = new TypeToken<List<SpeechModel>>(){}.getType();
    private static final Type TYPE_SESSION_STATUS = new TypeToken<SpeechSessionStatus>(){}.getType();

    public SpeechToText() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public SpeechToText(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    private void buildRecognizeRequest(RequestBuilder requestBuilder, RecognizeOptions options) {
        if (options == null) {
            return;
        }
        if (options.wordConfidence() != null) {
            requestBuilder.query(WORD_CONFIDENCE, options.wordConfidence());
        }
        if (options.continuous() != null) {
            requestBuilder.query(CONTINUOUS, options.continuous());
        }
        if (options.profanityFilter() != null) {
            requestBuilder.query(PROFANITY_FILTER, options.profanityFilter());
        }
        if (options.maxAlternatives() != null) {
            requestBuilder.query(MAX_ALTERNATIVES, options.maxAlternatives());
        }
        if (options.timestamps() != null) {
            requestBuilder.query(TIMESTAMPS, options.timestamps());
        }
        if (options.inactivityTimeout() != null) {
            requestBuilder.query(INACTIVITY_TIMEOUT, options.inactivityTimeout());
        }
        if (options.model() != null) {
            requestBuilder.query(MODEL, options.model());
        }
        if (options.keywordsThreshold() != null) {
            requestBuilder.query(KEYWORDS_THRESHOLD, options.keywordsThreshold());
        }
        if (options.keywords() != null && options.keywords().length > 0) {
            String keywords = RequestUtils.join(Arrays.asList(options.keywords()), ",");
            requestBuilder.query(KEYWORDS, RequestUtils.encode(keywords));
        }
        if (options.wordAlternativesThreshold() != null) {
            requestBuilder.query(WORD_ALTERNATIVES_THRESHOLD, options.wordAlternativesThreshold());
        }
    }

    public ServiceCall<SpeechSession> createSession() {
        String model = null;
        return this.createSession(model);
    }

    public ServiceCall<SpeechSession> createSession(SpeechModel model) {
        Validator.notNull(model, "Model cannot be null");
        return this.createSession(model.getName());
    }

    public ServiceCall<SpeechSession> createSession(String model) {
        RequestBuilder request = RequestBuilder.post(PATH_SESSIONS);
        if (model != null) {
            request.query(MODEL, model);
        }
        return this.createServiceCall(request.build(), ResponseConverterUtils.getObject(SpeechSession.class));
    }

    public ServiceCall<Void> deleteSession(SpeechSession session) {
        Validator.notNull(session, "session cannot be null");
        Request request = RequestBuilder.delete(String.format(PATH_SESSION, session.getSessionId())).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<SpeechModel> getModel(String modelName) {
        Validator.notNull(modelName, "name cannot be null");
        Request request = RequestBuilder.get(String.format(PATH_MODEL, modelName)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(SpeechModel.class));
    }

    public ServiceCall<List<SpeechModel>> getModels() {
        Request request = RequestBuilder.get(PATH_MODELS).build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject(TYPE_LIST_MODELS, "models");
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<SpeechSessionStatus> getRecognizeStatus(SpeechSession session) {
        Validator.notNull(session, "session cannot be null");
        Validator.notNull(session.getSessionId(), "session.sessionId cannot be null");
        Request request = RequestBuilder.get(String.format(PATH_SESSION_RECOGNIZE, session.getSessionId())).build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject(TYPE_SESSION_STATUS, "session");
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<SpeechResults> recognize(File audio) {
        return this.recognize(audio, null);
    }

    public ServiceCall<SpeechResults> recognize(File audio, RecognizeOptions options) {
        Validator.isTrue(audio != null && audio.exists(), "audio file is null or does not exist");
        double fileSize = (double)audio.length() / Math.pow(1024.0, 2.0);
        Validator.isTrue(fileSize < 100.0, "The audio file is greater than 100MB.");
        String contentType = MediaTypeUtils.getMediaTypeFromFile(audio);
        if (options != null && options.contentType() != null) {
            contentType = options.contentType();
        }
        Validator.notNull(contentType, "The audio format cannot be recognized");
        String path = PATH_RECOGNIZE;
        if (options != null && options.sessionId() != null && !options.sessionId().isEmpty()) {
            path = String.format(PATH_SESSION_RECOGNIZE, options.sessionId());
        }
        RequestBuilder requestBuilder = RequestBuilder.post(path);
        this.buildRecognizeRequest(requestBuilder, options);
        requestBuilder.body(RequestBody.create(MediaType.parse(contentType), audio));
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(SpeechResults.class));
    }

    public void recognizeUsingWebSocket(final InputStream audio, final RecognizeOptions options, final RecognizeCallback callback) {
        Validator.notNull(audio, "audio cannot be null");
        Validator.notNull(options, "options cannot be null");
        Validator.notNull(options.contentType(), "options.contentType cannot be null");
        Validator.notNull(callback, "callback cannot be null");
        this.getToken().enqueue(new ServiceCallback<String>(){

            @Override
            public void onFailure(Exception e) {
                callback.onError(e);
            }

            @Override
            public void onResponse(String token) {
                String url = SpeechToText.this.getEndPoint().replaceFirst("(https|http)", "wss");
                WebSocketManager wsManager = new WebSocketManager(url + SpeechToText.PATH_RECOGNIZE, SpeechToText.this.configureHttpClient(), token);
                wsManager.recognize(audio, options, callback);
            }
        });
    }
}

