/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.exception.BadRequestException;
import com.ibm.watson.developer_cloud.service.exception.ServiceResponseException;
import com.ibm.watson.developer_cloud.service.exception.TooManyRequestsException;
import com.ibm.watson.developer_cloud.service.exception.UnauthorizedException;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseUtils;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public abstract class AlchemyService
extends WatsonService {
    private static final String SERVICE_NAME = "alchemy_api";
    private static final String DAILY_TRANSACTION_LIMIT_EXCEEDED = "daily-transaction-limit-exceeded";
    private static final String INVALID_API_KEY = "invalid-api-key";
    private static final String PARAM_APIKEY = "apikey";
    private static final String STATUS_ERROR = "ERROR";
    private static final String X_ALCHEMY_API_ERROR_MSG = "X-AlchemyAPI-Error-Msg";
    private static final String X_ALCHEMY_API_STATUS = "X-AlchemyAPI-Status";
    private static final Logger LOG = Logger.getLogger(AlchemyService.class.getName());
    protected static final String ENDPOINT = "https://gateway-a.watsonplatform.net/calls";
    protected static final String JSONP = "jsonp";
    protected static final String OUTPUT_MODE = "outputMode";

    public AlchemyService() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(ENDPOINT);
        }
    }

    public AlchemyService(String apiKey) {
        this();
        this.setApiKey(apiKey);
    }

    private void addApiKeyToRequest(Request.Builder builder, String apiKey) {
        HttpUrl url = HttpUrl.parse(builder.build().url().toString());
        if (url.query() == null || url.query().isEmpty()) {
            builder.url(builder.build().url() + "?" + apiKey);
        } else {
            builder.url(builder.build().url() + "&" + apiKey);
        }
    }

    private int detectErrorCode(String errorMessage) {
        String error;
        String string = error = errorMessage != null ? errorMessage : null;
        if (error == null) {
            return 400;
        }
        if (error.equals(DAILY_TRANSACTION_LIMIT_EXCEEDED)) {
            return 429;
        }
        if (error.equals(INVALID_API_KEY)) {
            return 401;
        }
        return 400;
    }

    @Override
    protected <T> T processServiceCall(ResponseConverter<T> converter, Response response) {
        int code;
        String errorMessage;
        JsonObject error = this.getErrorMessage(response);
        if (response.isSuccessful() && error == null) {
            return converter.convert(response);
        }
        if (error != null) {
            errorMessage = error.get("error").getAsString();
            code = error.get("code").getAsInt();
        } else {
            errorMessage = null;
            code = -1;
        }
        LOG.log(Level.SEVERE, response.request().method() + " " + response.request().url().toString() + ", API status: " + response.code() + ", error: " + errorMessage);
        switch (code) {
            case 400: {
                throw new BadRequestException(errorMessage, response);
            }
            case 401: {
                throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials", response);
            }
            case 429: {
                throw new TooManyRequestsException(errorMessage, response);
            }
        }
        throw new ServiceResponseException(code, errorMessage, response);
    }

    private JsonObject getErrorMessage(Response response) {
        String status = response.header(X_ALCHEMY_API_STATUS);
        String errorMessage = response.header(X_ALCHEMY_API_ERROR_MSG);
        if (STATUS_ERROR.equals(status)) {
            int code = this.detectErrorCode(errorMessage);
            JsonObject error = new JsonObject();
            error.addProperty("error", errorMessage != null ? errorMessage : "Unknown error");
            error.addProperty("code", code);
            ResponseUtils.getString(response);
            return error;
        }
        return null;
    }

    protected String getInputFormat(Map<String, Object> params, String ... acceptedFormats) {
        int i;
        for (i = 0; i < acceptedFormats.length && params != null && !params.containsKey(acceptedFormats[i]); ++i) {
        }
        if (params == null || i == acceptedFormats.length) {
            throw new IllegalArgumentException(RequestUtils.join(acceptedFormats, ",") + " should be specified");
        }
        return acceptedFormats[i];
    }

    @Override
    protected void setAuthentication(Request.Builder builder) {
        if (this.getApiKey() == null) {
            throw new IllegalArgumentException("apiKey not specified");
        }
        this.addApiKeyToRequest(builder, "apikey=" + this.getApiKey());
    }
}

