/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.retrieve_and_rank.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.ClusterLifecycleManager;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.SolrConfigManager;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.Ranker;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.Rankers;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.Ranking;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrCluster;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrClusterOptions;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrClusterResizeRequest;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrClusterSizeResponse;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrClusterStats;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrClusters;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrConfigs;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util.ZipUtils;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RetrieveAndRank
extends WatsonService
implements ClusterLifecycleManager,
SolrConfigManager {
    private static final String ANSWERS = "answers";
    private static final Logger LOG = Logger.getLogger(RetrieveAndRank.class.getName());
    private static final String NAME = "name";
    private static final String PATH_CREATE_RANKER = "/v1/rankers";
    private static final String PATH_GET_SOLR_CLUSTER = "/v1/solr_clusters/%s";
    private static final String PATH_SOLR = "/v1/solr_clusters/%s/solr";
    private static final String PATH_RANK = "/v1/rankers/%s/rank";
    private static final String PATH_RANKER = "/v1/rankers/%s";
    private static final String PATH_RANKERS = "/v1/rankers";
    private static final String PATH_SOLR_CLUSTERS = "/v1/solr_clusters";
    private static final String PATH_SOLR_CLUSTERS_CONFIG = "/v1/solr_clusters/%s/config";
    private static final String PATH_SOLR_CLUSTERS_CONFIGS = "/v1/solr_clusters/%s/config/%s";
    private static final String URL = "https://gateway.watsonplatform.net/retrieve-and-rank/api";
    private static final String PATH_SOLR_CLUSTERS_SIZE = "/v1/solr_clusters/%s/cluster_size";

    public RetrieveAndRank() {
        super("retrieve_and_rank");
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public RetrieveAndRank(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    private String createConfigPath(String solrClusterId, String configName) {
        Validator.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Validator.isTrue(configName != null && !configName.isEmpty(), "configName cannot be null or empty");
        return String.format(PATH_SOLR_CLUSTERS_CONFIGS, solrClusterId, configName);
    }

    public ServiceCall<Ranker> createRanker(String name, File training) {
        Validator.notNull(training, "training file cannot be null");
        Validator.isTrue(training.exists(), "training file: " + training.getAbsolutePath() + " not found");
        JsonObject contentJson = new JsonObject();
        if (name != null && !name.isEmpty()) {
            contentJson.addProperty(NAME, name);
        }
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(Headers.of("Content-Disposition", "form-data; name=\"training_data\""), RequestBody.create(HttpMediaType.BINARY_FILE, training)).addPart(Headers.of("Content-Disposition", "form-data; name=\"training_metadata\""), RequestBody.create(HttpMediaType.TEXT, contentJson.toString())).build();
        Request request = RequestBuilder.post("/v1/rankers").body(body).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Ranker.class));
    }

    @Override
    public ServiceCall<SolrCluster> createSolrCluster() {
        return this.createSolrCluster(null);
    }

    @Override
    public ServiceCall<SolrCluster> createSolrCluster(SolrClusterOptions config) {
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_SOLR_CLUSTERS);
        if (config != null) {
            requestBuilder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(config), "application/json");
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(SolrCluster.class));
    }

    public ServiceCall<Void> deleteRanker(String rankerID) {
        Validator.isTrue(rankerID != null && !rankerID.isEmpty(), "rankerId cannot be null or empty");
        Request request = RequestBuilder.delete(String.format(PATH_RANKER, rankerID)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    @Override
    public ServiceCall<Void> deleteSolrCluster(String solrClusterId) {
        Validator.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Request request = RequestBuilder.delete(String.format(PATH_GET_SOLR_CLUSTER, solrClusterId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    @Override
    public ServiceCall<Void> deleteSolrClusterConfiguration(String solrClusterId, String configName) {
        String configPath = this.createConfigPath(solrClusterId, configName);
        Request request = RequestBuilder.delete(configPath).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Rankers> getRankers() {
        Request request = RequestBuilder.get("/v1/rankers").build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Rankers.class));
    }

    public ServiceCall<Ranker> getRankerStatus(String rankerID) {
        Validator.isTrue(rankerID != null && !rankerID.isEmpty(), "rankerId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_RANKER, rankerID)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Ranker.class));
    }

    @Override
    public ServiceCall<SolrCluster> getSolrCluster(String solrClusterId) {
        Validator.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_GET_SOLR_CLUSTER, solrClusterId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(SolrCluster.class));
    }

    @Override
    public ServiceCall<InputStream> getSolrClusterConfiguration(String solrClusterId, String configName) {
        Validator.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Validator.isTrue(configName != null && !configName.isEmpty(), "configName cannot be null or empty");
        String configPath = this.createConfigPath(solrClusterId, configName);
        RequestBuilder requestBuider = RequestBuilder.get(configPath).header("Accept", "application/zip");
        return this.createServiceCall(requestBuider.build(), ResponseConverterUtils.getInputStream());
    }

    @Override
    public ServiceCall<SolrConfigs> getSolrClusterConfigurations(String solrClusterId) {
        Validator.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_SOLR_CLUSTERS_CONFIG, solrClusterId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(SolrConfigs.class));
    }

    @Override
    public ServiceCall<SolrClusters> getSolrClusters() {
        Request request = RequestBuilder.get(PATH_SOLR_CLUSTERS).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(SolrClusters.class));
    }

    public ServiceCall<SolrClusterStats> getSolrClusterStats(String solrClusterId) {
        Validator.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_GET_SOLR_CLUSTER, solrClusterId) + "/stats").build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(SolrClusterStats.class));
    }

    public String getSolrUrl(String solrClusterId) {
        return this.getEndPoint() + String.format(PATH_SOLR, solrClusterId);
    }

    public ServiceCall<Ranking> rank(String rankerID, File answers, Integer topAnswers) {
        Validator.isTrue(rankerID != null && !rankerID.isEmpty(), "rankerID cannot be null or empty");
        Validator.notNull(answers, "answers file cannot be null");
        Validator.isTrue(answers.exists(), "answers file: " + answers.getAbsolutePath() + " not found");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(ANSWERS, topAnswers != null && topAnswers > 0 ? topAnswers : 10);
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(Headers.of("Content-Disposition", "form-data; name=\"answer_data\""), RequestBody.create(HttpMediaType.BINARY_FILE, answers)).addPart(Headers.of("Content-Disposition", "form-data; name=\"answer_metadata\""), RequestBody.create(HttpMediaType.TEXT, contentJson.toString())).build();
        String path = String.format(PATH_RANK, rankerID);
        Request request = RequestBuilder.post(path).body(body).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Ranking.class));
    }

    public ServiceCall<Ranking> rank(String rankerID, InputStream answers, Integer topAnswers) {
        Validator.isTrue(rankerID != null && !rankerID.isEmpty(), "rankerID cannot be null or empty");
        Validator.notNull(answers, "answers file cannot be null");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(ANSWERS, topAnswers != null && topAnswers > 0 ? topAnswers : 10);
        ByteArrayOutputStream answersBuffer = new ByteArrayOutputStream();
        byte[] data = new byte[10000];
        try {
            int bytesRead;
            while ((bytesRead = answers.read(data, 0, data.length)) != -1) {
                answersBuffer.write(data, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading search results input", e);
        }
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(Headers.of("Content-Disposition", "form-data; name=\"answer_data\""), RequestBody.create(HttpMediaType.BINARY_FILE, answersBuffer.toByteArray())).addPart(Headers.of("Content-Disposition", "form-data; name=\"answer_metadata\""), RequestBody.create(HttpMediaType.TEXT, contentJson.toString())).build();
        String path = String.format(PATH_RANK, rankerID);
        Request request = RequestBuilder.post(path).body(body).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Ranking.class));
    }

    @Override
    public ServiceCall<Void> uploadSolrClusterConfigurationDirectory(String solrClusterId, String configName, File directory) {
        Validator.notNull(directory, "directory cannot be null");
        Validator.isTrue(directory.exists(), "directory: " + directory.getAbsolutePath() + " not found");
        Validator.isTrue(directory.isDirectory(), "directory is not a directory");
        final File zipFile = ZipUtils.buildConfigZip(configName, directory);
        RequestBuilder requestBuilder = this.createUploadSolrConfigurationRequest(solrClusterId, configName, zipFile);
        return this.createServiceCall(requestBuilder.build(), new ResponseConverter<Void>(){

            @Override
            public Void convert(Response response) {
                if (!zipFile.delete()) {
                    zipFile.deleteOnExit();
                    LOG.log(Level.WARNING, "Unable to delete the Solr cluster configuration file.");
                }
                return null;
            }
        });
    }

    @Override
    public ServiceCall<Void> uploadSolrClusterConfigurationZip(String solrClusterId, String configName, File zippedConfig) {
        RequestBuilder requestBuilder = this.createUploadSolrConfigurationRequest(solrClusterId, configName, zippedConfig);
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getVoid());
    }

    private RequestBuilder createUploadSolrConfigurationRequest(String solrClusterId, String configName, File zippedConfig) {
        String configPath = this.createConfigPath(solrClusterId, configName);
        RequestBuilder requestBuilder = RequestBuilder.post(configPath);
        requestBuilder.body(RequestBody.create(MediaType.parse("application/zip"), zippedConfig));
        return requestBuilder;
    }

    @Override
    public ServiceCall<SolrClusterSizeResponse> resizeSolrCluster(String SolrClusterId, int requestedSize) {
        Request request = this.buildResizeRequest(SolrClusterId, requestedSize);
        return this.createServiceCall(request, ResponseConverterUtils.getObject(SolrClusterSizeResponse.class));
    }

    @Override
    public ServiceCall<SolrClusterSizeResponse> getSolrClusterResizeStatus(String SolrClusterId) {
        Request request = this.buildGetSizeRequest(SolrClusterId);
        return this.createServiceCall(request, ResponseConverterUtils.getObject(SolrClusterSizeResponse.class));
    }

    private Request buildResizeRequest(String solrClusterId, int desiredSize) {
        String resizePath = this.createSizePath(solrClusterId);
        SolrClusterResizeRequest resizeRequest = new SolrClusterResizeRequest(desiredSize);
        RequestBuilder requestBuilder = RequestBuilder.put(resizePath);
        requestBuilder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(resizeRequest), "application/json");
        return requestBuilder.build();
    }

    private String createSizePath(String solrClusterId) {
        Validator.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        return String.format(PATH_SOLR_CLUSTERS_SIZE, solrClusterId);
    }

    private Request buildGetSizeRequest(String solrClusterId) {
        String resizePath = this.createSizePath(solrClusterId);
        RequestBuilder requestBuilder = RequestBuilder.get(resizePath);
        return requestBuilder.build();
    }
}

