/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v2.model;

import com.ibm.watson.developer_cloud.personality_insights.v2.model.AcceptLanguage;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.ContentItem;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.Language;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ProfileOptions {
    private AcceptLanguage acceptLanguage;
    private List<ContentItem> contentItems;
    private String contentType;
    private Boolean includeRaw;
    private Language language;
    private String text;

    private ProfileOptions(Builder builder) {
        Validator.isTrue(builder.text != null && !builder.text.isEmpty() || builder.contentItems != null && !builder.contentItems.isEmpty(), "text or contentItems are required");
        this.text = builder.text;
        this.contentType = builder.contentType;
        this.contentItems = builder.contentItems;
        this.includeRaw = builder.includeRaw;
        this.acceptLanguage = builder.acceptLanguage;
        this.language = builder.language;
    }

    public AcceptLanguage acceptLanguage() {
        return this.acceptLanguage;
    }

    public List<ContentItem> contentItems() {
        return this.contentItems;
    }

    public String contentType() {
        return this.contentType;
    }

    public Boolean includeRaw() {
        return this.includeRaw;
    }

    public Language language() {
        return this.language;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public static class Builder {
        private AcceptLanguage acceptLanguage;
        private List<ContentItem> contentItems;
        private String contentType;
        private Boolean includeRaw;
        private Language language;
        private String text;

        private Builder(ProfileOptions options) {
            this.text = options.text;
            this.contentType = options.contentType;
            this.contentItems = options.contentItems;
            this.includeRaw = options.includeRaw;
            this.acceptLanguage = options.acceptLanguage;
            this.language = options.language;
        }

        public Builder() {
        }

        public Builder acceptLanguage(AcceptLanguage acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder addContentItem(ContentItem contentItem) {
            if (this.contentItems == null) {
                this.contentItems = new ArrayList<ContentItem>();
                this.contentType = "application/json";
            }
            this.contentItems.add(contentItem);
            return this;
        }

        public ProfileOptions build() {
            return new ProfileOptions(this);
        }

        public Builder contentItems(List<ContentItem> contentItems) {
            this.contentItems = contentItems;
            this.contentType = "application/json";
            return this;
        }

        public Builder html(String html) {
            this.text = html;
            this.contentType = "text/html";
            return this;
        }

        public Builder includeRaw(boolean includeRaw) {
            this.includeRaw = includeRaw;
            return this;
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.contentType = "text/plain";
            return this;
        }
    }
}

