/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v2;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.Content;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.Profile;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.ProfileOptions;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;

public class PersonalityInsights
extends WatsonService {
    private static final String SERVICE_NAME = "personality_insights";
    private static final String PATH_PROFILE = "/v2/profile";
    private static final String INCLUDE_RAW = "include_raw";
    private static final String URL = "https://gateway.watsonplatform.net/personality-insights/api";
    private static final String HEADERS = "headers";

    public PersonalityInsights() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public PersonalityInsights(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    private RequestBuilder buildProfileRequest(ProfileOptions options) {
        Validator.notNull(options, "options cannot be null");
        Validator.isTrue(options.text() != null || options.contentItems() != null, "text, html or content items need to be specified");
        String contentType = options.contentType();
        RequestBuilder request = RequestBuilder.post(PATH_PROFILE);
        if (options.text() != null) {
            request.header("Content-Type", contentType);
            request.bodyContent(options.text(), contentType);
        } else {
            Content content = new Content();
            content.setContentItems(options.contentItems());
            String body = GsonSingleton.getGson().toJson(content);
            request.bodyContent(body, contentType);
        }
        if (options.includeRaw() != null) {
            request.query(INCLUDE_RAW, options.includeRaw());
        }
        if (options.language() != null) {
            request.header(new Object[]{"Content-Language", options.language()});
        }
        if (options.acceptLanguage() != null) {
            request.header(new Object[]{"Accept-Language", options.acceptLanguage()});
        }
        return request;
    }

    public ServiceCall<Profile> getProfile(String text) {
        Validator.notEmpty(text, "text cannot be null or empty");
        ProfileOptions options = new ProfileOptions.Builder().text(text).build();
        RequestBuilder requestBuilder = this.buildProfileRequest(options);
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(Profile.class));
    }

    public ServiceCall<Profile> getProfile(ProfileOptions options) {
        RequestBuilder requestBuilder = this.buildProfileRequest(options);
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(Profile.class));
    }

    public ServiceCall<String> getProfileAsCSV(ProfileOptions options, boolean includeHeaders) {
        RequestBuilder requestBuilder = this.buildProfileRequest(options);
        requestBuilder.header("Accept", "text/csv");
        requestBuilder.query(HEADERS, includeHeaders);
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getString());
    }
}

